#! /usr/bin/env python
# -*- coding: utf-8 -*-


###############################################################################
# plasma_testing.py  [nbcores] 
#  nbcores is a optional argument to give the number of cores to run the testing
# Example:
#     ./plasma_testing.py 
#                 No argument, so will run on half of the core if the machine has more than 2 cores
#     ./plama_testing.py nbcores
#                 Will run on nbcores 
###############################################################################

import os, sys, math

# Linux Unix and MacOS: 
if hasattr(os, "sysconf"):
   if os.sysconf_names.has_key("SC_NPROCESSORS_ONLN"):
	   ncpus_av = os.sysconf("SC_NPROCESSORS_ONLN")
# Windows:
if os.environ.has_key("NUMBER_OF_PROCESSORS"):
   ncpus_av = int(os.environ["NUMBER_OF_PROCESSORS"]);

# If the user is proving us the number of core and this number is less than total core of the machine
if ((len(sys.argv)>1) and (int(sys.argv[1])<=ncpus_av)):
	ncpus=sys.argv[1]
else:
   # we are going to run on half of the cores by default if we have more than 2 cores
   if (ncpus_av > 2):
      ncpus=int(math.floor(ncpus_av/2))
   else:
      ncpus=ncpus_av

# Add current directory to the path for subshells of this shell
# Allows the popen to find local files in both windows and unixes
os.environ["PATH"] = os.environ["PATH"]+":."

# Define a function to open the executable (different filenames on unix and Windows)
def local_popen( cmdline ):
   if os.name == 'nt':
     pipe=os.popen( cmdline )
   else:
     pipe=os.popen( "./" + cmdline )
   return pipe


# If filename cannot be opened, send output to sys.stderr
filename = "testing_results.txt"
try:
     f = open(filename, 'w')
except IOError:
     f = sys.stdout

print " "
print "---------------- Testing PLASMA Routines ----------------"
print " "
print "-- Number of cores available =", ncpus_av
print "-- Number of cores used for testing =", ncpus
print "-- Detailed results are stored in", filename

dtypes = (
("s", "d", "c", "z"),
("Single", "Double", "Complex", "Double Complex"),
)

for dtype in range(4):
  letter = dtypes[0][dtype]
  name = dtypes[1][dtype]
  print " "
  print "------------------------- %s ------------------------" % name
  print " "
  sys.stdout.flush()

  test1 = local_popen("testing_%sposv " % letter +str(ncpus)+ " 500 600 25 700")
  for line in test1.readlines():
       f.write(str(line))
       if "TESTING" in line : print line,
  f.flush()
  sys.stdout.flush()

  test2=local_popen("testing_%sgels " % letter +str(ncpus)+ " 800 400 825 25 810")
  for line in test2.readlines():
       f.write(str(line))
       if "TESTING" in line : print line,
  f.flush()
  sys.stdout.flush()

  test3=local_popen("testing_%sgels " % letter +str(ncpus)+ " 400 800 825 25 810")
  for line in test3.readlines():
       f.write(str(line))
       if "TESTING" in line : print line,
  f.flush()
  sys.stdout.flush()

  test4=local_popen("testing_%sgesv " % letter +str(ncpus)+ " 800 825 25 810")
  for line in test4.readlines():
       f.write(str(line))
       if "TESTING" in line : print line,
  f.flush()
  sys.stdout.flush()

  test5=local_popen("testing_%sgemm " % letter +str(ncpus)+ " 1.0 -2.0 600 500 550 650 550 600")
  for line in test5.readlines():
       f.write(str(line))
       if "TESTING" in line : print line,
  f.flush()

print " "
print "--------------------- Mixed Precision -------------------"
print " "

for substr in ("zc", "ds"):
  test17=local_popen("testing_%sgesv " % substr +str(ncpus)+ " 800 825 25 810")
  for line in test17.readlines():
       f.write(str(line))
       if "TESTING" in line : print line,
  f.flush()
  sys.stdout.flush()


# This may close the sys.stdout stream, so make it the last statement
f.close()
