/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak                                               ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"
#include "workspace.h"

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_zgels - Allocates workspace for PLASMA_zgels or PLASMA_zgels_Tile
// routine.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// M        int (IN)
//          The number of rows of the matrix A. M >= 0.
//
// N        int (IN)
//          The number of columns of the matrix A.  N >= 0.
//
// T        PLASMA_Complex64_t* (OUT)
//          On exit, workspace handle for storage of the extra T factors required by the tile QR
//          or the tile LQ factorization.

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_zgels(int M, int N, PLASMA_Complex64_t **T) {
    return plasma_alloc_ibnb(M, N, PLASMA_FUNC_ZGELS, PlasmaComplexDouble, (void**)T); }

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_zgeqrf - Allocates workspace for PLASMA_zgeqrf or PLASMA_zgeqrf_Tile
// routine.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// M        int (IN)
//          The number of rows of the matrix A. M >= 0.
//
// N        int (IN)
//          The number of columns of the matrix A.  N >= 0.
//
// T        PLASMA_Complex64_t* (OUT)
//          On exit, workspace handle for storage of the extra T factors required by the tile QR
//          factorization.

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_zgeqrf(int M, int N, PLASMA_Complex64_t **T) {
    return plasma_alloc_ibnb(M, N, PLASMA_FUNC_ZGELS, PlasmaComplexDouble, (void**)T); }

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_zgelqf - Allocates workspace for PLASMA_zgelqf or PLASMA_zgelqf_Tile
// routines.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// M        int (IN)
//          The number of rows of the matrix A. M >= 0.
//
// N        int (IN)
//          The number of columns of the matrix A.  N >= 0.
//
// T        PLASMA_Complex64_t* (OUT)
//          On exit, workspace handle for storage of the extra T factors required by the tile LQ
//          factorization.

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_zgelqf(int M, int N, PLASMA_Complex64_t **T) {
    return plasma_alloc_ibnb(M, N, PLASMA_FUNC_ZGELS, PlasmaComplexDouble, (void**)T); }

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_zgesv - Allocates workspace for PLASMA_zgesv or PLASMA_zgesv_Tile
// routines.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// N        int (IN)
//          The number of linear equations, i.e., the order of the matrix A. N >= 0.
//
// L        PLASMA_Complex64_t* (OUT)
//          On exit, workspace handle for storage of the extra L factors required by the tile LU
//          factorization.
//
// IPIV     int** (OUT)
//          On exit, workspace handle for storage of pivot indexes required by the tile LU
//          factorization (not equivalent to LAPACK).

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_zgesv(int N, PLASMA_Complex64_t **L, int **IPIV) {
    int status = plasma_alloc_ibnb(N, N, PLASMA_FUNC_ZGESV, PlasmaComplexDouble, (void**)L);
    if (status != PLASMA_SUCCESS)
        return status;
    return plasma_alloc_ipiv(N, N, PLASMA_FUNC_ZGESV, (void**)IPIV); }

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_zgetrf - Allocates workspace for PLASMA_zgetrf or PLASMA_zgetrf_Tile
// routines.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// M        int (IN)
//          The number of rows of the matrix A. M >= 0.
//
// N        int (IN)
//          The number of columns of the matrix A.  N >= 0.
//
// L        PLASMA_Complex64_t* (OUT)
//          On exit, workspace handle for storage of the extra L factors required by the tile LU
//          factorization.
//
// IPIV     int** (OUT)
//          On exit, workspace handle for storage of pivot indexes required by the tile LU
//          factorization (not equivalent to LAPACK).

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_zgetrf(int M, int N, PLASMA_Complex64_t **L, int **IPIV) {
    int status = plasma_alloc_ibnb(M, N, PLASMA_FUNC_ZGESV, PlasmaComplexDouble, (void**)L);
    if (status != PLASMA_SUCCESS)
        return status;
    return plasma_alloc_ipiv(M, N, PLASMA_FUNC_ZGESV, (void**)IPIV); }
