/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak                                               ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"
#include "workspace.h"

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_sgels - Allocates workspace for PLASMA_sgels or PLASMA_sgels_Tile
// routine.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// M        int (IN)
//          The number of rows of the matrix A. M >= 0.
//
// N        int (IN)
//          The number of columns of the matrix A.  N >= 0.
//
// T        float* (OUT)
//          On exit, workspace handle for storage of the extra T factors required by the tile QR
//          or the tile LQ factorization.

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_sgels(int M, int N, float **T) {
    return plasma_alloc_ibnb(M, N, PLASMA_FUNC_SGELS, PlasmaRealFloat, (void**)T); }

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_sgeqrf - Allocates workspace for PLASMA_sgeqrf or PLASMA_sgeqrf_Tile
// routine.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// M        int (IN)
//          The number of rows of the matrix A. M >= 0.
//
// N        int (IN)
//          The number of columns of the matrix A.  N >= 0.
//
// T        float* (OUT)
//          On exit, workspace handle for storage of the extra T factors required by the tile QR
//          factorization.

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_sgeqrf(int M, int N, float **T) {
    return plasma_alloc_ibnb(M, N, PLASMA_FUNC_SGELS, PlasmaRealFloat, (void**)T); }

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_sgelqf - Allocates workspace for PLASMA_sgelqf or PLASMA_sgelqf_Tile
// routines.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// M        int (IN)
//          The number of rows of the matrix A. M >= 0.
//
// N        int (IN)
//          The number of columns of the matrix A.  N >= 0.
//
// T        float* (OUT)
//          On exit, workspace handle for storage of the extra T factors required by the tile LQ
//          factorization.

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_sgelqf(int M, int N, float **T) {
    return plasma_alloc_ibnb(M, N, PLASMA_FUNC_SGELS, PlasmaRealFloat, (void**)T); }

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_sgesv - Allocates workspace for PLASMA_sgesv or PLASMA_sgesv_Tile
// routines.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// N        int (IN)
//          The number of linear equations, i.e., the order of the matrix A. N >= 0.
//
// L        float* (OUT)
//          On exit, workspace handle for storage of the extra L factors required by the tile LU
//          factorization.
//
// IPIV     int** (OUT)
//          On exit, workspace handle for storage of pivot indexes required by the tile LU
//          factorization (not equivalent to LAPACK).

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_sgesv(int N, float **L, int **IPIV) {
    int status = plasma_alloc_ibnb(N, N, PLASMA_FUNC_SGESV, PlasmaRealFloat, (void**)L);
    if (status != PLASMA_SUCCESS)
        return status;
    return plasma_alloc_ipiv(N, N, PLASMA_FUNC_SGESV, (void**)IPIV); }

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_sgetrf - Allocates workspace for PLASMA_sgetrf or PLASMA_sgetrf_Tile
// routines.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// M        int (IN)
//          The number of rows of the matrix A. M >= 0.
//
// N        int (IN)
//          The number of columns of the matrix A.  N >= 0.
//
// L        float* (OUT)
//          On exit, workspace handle for storage of the extra L factors required by the tile LU
//          factorization.
//
// IPIV     int** (OUT)
//          On exit, workspace handle for storage of pivot indexes required by the tile LU
//          factorization (not equivalent to LAPACK).

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_sgetrf(int M, int N, float **L, int **IPIV) {
    int status = plasma_alloc_ibnb(M, N, PLASMA_FUNC_SGESV, PlasmaRealFloat, (void**)L);
    if (status != PLASMA_SUCCESS)
        return status;
    return plasma_alloc_ipiv(M, N, PLASMA_FUNC_SGESV, (void**)IPIV); }
