/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak                                               ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"
#include "workspace.h"

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_dgels - Allocates workspace for PLASMA_dgels or PLASMA_dgels_Tile
// routine.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// M        int (IN)
//          The number of rows of the matrix A. M >= 0.
//
// N        int (IN)
//          The number of columns of the matrix A.  N >= 0.
//
// T        double* (OUT)
//          On exit, workspace handle for storage of the extra T factors required by the tile QR
//          or the tile LQ factorization.

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_dgels(int M, int N, double **T) {
    return plasma_alloc_ibnb(M, N, PLASMA_FUNC_DGELS, PlasmaRealDouble, (void**)T); }

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_dgeqrf - Allocates workspace for PLASMA_dgeqrf or PLASMA_dgeqrf_Tile
// routine.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// M        int (IN)
//          The number of rows of the matrix A. M >= 0.
//
// N        int (IN)
//          The number of columns of the matrix A.  N >= 0.
//
// T        double* (OUT)
//          On exit, workspace handle for storage of the extra T factors required by the tile QR
//          factorization.

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_dgeqrf(int M, int N, double **T) {
    return plasma_alloc_ibnb(M, N, PLASMA_FUNC_DGELS, PlasmaRealDouble, (void**)T); }

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_dgelqf - Allocates workspace for PLASMA_dgelqf or PLASMA_dgelqf_Tile
// routines.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// M        int (IN)
//          The number of rows of the matrix A. M >= 0.
//
// N        int (IN)
//          The number of columns of the matrix A.  N >= 0.
//
// T        double* (OUT)
//          On exit, workspace handle for storage of the extra T factors required by the tile LQ
//          factorization.

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_dgelqf(int M, int N, double **T) {
    return plasma_alloc_ibnb(M, N, PLASMA_FUNC_DGELS, PlasmaRealDouble, (void**)T); }

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_dgesv - Allocates workspace for PLASMA_dgesv or PLASMA_dgesv_Tile
// routines.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// N        int (IN)
//          The number of linear equations, i.e., the order of the matrix A. N >= 0.
//
// L        double* (OUT)
//          On exit, workspace handle for storage of the extra L factors required by the tile LU
//          factorization.
//
// IPIV     int** (OUT)
//          On exit, workspace handle for storage of pivot indexes required by the tile LU
//          factorization (not equivalent to LAPACK).

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_dgesv(int N, double **L, int **IPIV) {
    int status = plasma_alloc_ibnb(N, N, PLASMA_FUNC_DGESV, PlasmaRealDouble, (void**)L);
    if (status != PLASMA_SUCCESS)
        return status;
    return plasma_alloc_ipiv(N, N, PLASMA_FUNC_DGESV, (void**)IPIV); }

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_dgetrf - Allocates workspace for PLASMA_dgetrf or PLASMA_dgetrf_Tile
// routines.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// M        int (IN)
//          The number of rows of the matrix A. M >= 0.
//
// N        int (IN)
//          The number of columns of the matrix A.  N >= 0.
//
// L        double* (OUT)
//          On exit, workspace handle for storage of the extra L factors required by the tile LU
//          factorization.
//
// IPIV     int** (OUT)
//          On exit, workspace handle for storage of pivot indexes required by the tile LU
//          factorization (not equivalent to LAPACK).

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_dgetrf(int M, int N, double **L, int **IPIV) {
    int status = plasma_alloc_ibnb(M, N, PLASMA_FUNC_DGESV, PlasmaRealDouble, (void**)L);
    if (status != PLASMA_SUCCESS)
        return status;
    return plasma_alloc_ipiv(M, N, PLASMA_FUNC_DGESV, (void**)IPIV); }
