/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak                                               ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"
#include "workspace.h"

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_cgels - Allocates workspace for PLASMA_cgels or PLASMA_cgels_Tile
// routine.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// M        int (IN)
//          The number of rows of the matrix A. M >= 0.
//
// N        int (IN)
//          The number of columns of the matrix A.  N >= 0.
//
// T        PLASMA_Complex32_t* (OUT)
//          On exit, workspace handle for storage of the extra T factors required by the tile QR
//          or the tile LQ factorization.

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_cgels(int M, int N, PLASMA_Complex32_t **T) {
    return plasma_alloc_ibnb(M, N, PLASMA_FUNC_CGELS, PlasmaComplexFloat, (void**)T); }

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_cgeqrf - Allocates workspace for PLASMA_cgeqrf or PLASMA_cgeqrf_Tile
// routine.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// M        int (IN)
//          The number of rows of the matrix A. M >= 0.
//
// N        int (IN)
//          The number of columns of the matrix A.  N >= 0.
//
// T        PLASMA_Complex32_t* (OUT)
//          On exit, workspace handle for storage of the extra T factors required by the tile QR
//          factorization.

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_cgeqrf(int M, int N, PLASMA_Complex32_t **T) {
    return plasma_alloc_ibnb(M, N, PLASMA_FUNC_CGELS, PlasmaComplexFloat, (void**)T); }

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_cgelqf - Allocates workspace for PLASMA_cgelqf or PLASMA_cgelqf_Tile
// routines.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// M        int (IN)
//          The number of rows of the matrix A. M >= 0.
//
// N        int (IN)
//          The number of columns of the matrix A.  N >= 0.
//
// T        PLASMA_Complex32_t* (OUT)
//          On exit, workspace handle for storage of the extra T factors required by the tile LQ
//          factorization.

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_cgelqf(int M, int N, PLASMA_Complex32_t **T) {
    return plasma_alloc_ibnb(M, N, PLASMA_FUNC_CGELS, PlasmaComplexFloat, (void**)T); }

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_cgesv - Allocates workspace for PLASMA_cgesv or PLASMA_cgesv_Tile
// routines.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// N        int (IN)
//          The number of linear equations, i.e., the order of the matrix A. N >= 0.
//
// L        PLASMA_Complex32_t* (OUT)
//          On exit, workspace handle for storage of the extra L factors required by the tile LU
//          factorization.
//
// IPIV     int** (OUT)
//          On exit, workspace handle for storage of pivot indexes required by the tile LU
//          factorization (not equivalent to LAPACK).

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_cgesv(int N, PLASMA_Complex32_t **L, int **IPIV) {
    int status = plasma_alloc_ibnb(N, N, PLASMA_FUNC_CGESV, PlasmaComplexFloat, (void**)L);
    if (status != PLASMA_SUCCESS)
        return status;
    return plasma_alloc_ipiv(N, N, PLASMA_FUNC_CGESV, (void**)IPIV); }

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// PLASMA_Alloc_Workspace_cgetrf - Allocates workspace for PLASMA_cgetrf or PLASMA_cgetrf_Tile
// routines.

/* ///////////////////// A /// R /// G /// U /// M /// E /// N /// T /// S ///////////////////// */
// M        int (IN)
//          The number of rows of the matrix A. M >= 0.
//
// N        int (IN)
//          The number of columns of the matrix A.  N >= 0.
//
// L        PLASMA_Complex32_t* (OUT)
//          On exit, workspace handle for storage of the extra L factors required by the tile LU
//          factorization.
//
// IPIV     int** (OUT)
//          On exit, workspace handle for storage of pivot indexes required by the tile LU
//          factorization (not equivalent to LAPACK).

/* ///////////// R /// E /// T /// U /// R /// N /////// V /// A /// L /// U /// E ///////////// */
//          = 0: successful exit

/* //////////////////////////////////// C /// O /// D /// E //////////////////////////////////// */
int PLASMA_Alloc_Workspace_cgetrf(int M, int N, PLASMA_Complex32_t **L, int **IPIV) {
    int status = plasma_alloc_ibnb(M, N, PLASMA_FUNC_CGESV, PlasmaComplexFloat, (void**)L);
    if (status != PLASMA_SUCCESS)
        return status;
    return plasma_alloc_ipiv(M, N, PLASMA_FUNC_CGESV, (void**)IPIV); }
