/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak                                               ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#ifndef _PLASMA_WORKSPACE_H_
#define _PLASMA_WORKSPACE_H_

#ifdef __cplusplus
extern "C" {
#endif

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Internal routines
int plasma_alloc_ibnb(int M, int N, int operation, int type, void **memptr);
int plasma_alloc_ipiv(int M, int N, int operation, void **memptr);

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  User routines
int PLASMA_Dealloc_Handle(void **handle);

#include "workspace_z.h"
#include "workspace_d.h"
#include "workspace_c.h"
#include "workspace_s.h"

#ifdef __cplusplus
}
#endif

#endif
