/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak, Hatem Ltaief                                 ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Parallel tile LU factorization
#define A(m,n) &((PLASMA_Complex64_t*)A.mat)[A.bsiz*(m)+A.bsiz*A.lmt*(n)]
#define L(m,n) &((PLASMA_Complex64_t*)L.mat)[L.bsiz*(m)+L.bsiz*L.lmt*(n)]
#define IPIV(m,n) &IPIV[A.nb*(m)+A.nb*A.lmt*(n)]
void plasma_pzgetrf(plasma_context_t *plasma)
{
    PLASMA_desc A;
    PLASMA_desc L;
    int*        IPIV;

    int k, m, n;
    int next_k;
    int next_m;
    int next_n;
    int iinfo;
    PLASMA_Complex64_t *work;

    plasma_unpack_args_3(A, L, IPIV);
    work = (PLASMA_Complex64_t *)plasma_private_alloc(plasma, L.mb*L.nb, L.dtyp);
    ss_init(A.mt, A.nt, -1);

    k = 0;
    n = PLASMA_RANK;
    while (n >= A.nt) {
        k++;
        n = n-A.nt+k;
    }
    m = k;

    while (k < min(A.mt, A.nt) && n < A.nt) {
        next_n = n;
        next_m = m;
        next_k = k;

        next_m++;
        if (next_m == A.mt) {
            next_n += PLASMA_SIZE;
            while (next_n >= A.nt && next_k < min(A.mt, A.nt)) {
                next_k++;
                next_n = next_n-A.nt+next_k;
            }
            next_m = next_k;
        }

        if (n == k) {
            if (m == k) {
                ss_cond_wait(k, k, k-1);
                CORE_zgetrf(
                    k == A.mt-1 ? A.m-k*A.nb : A.nb,
                    k == A.nt-1 ? A.n-k*A.nb : A.nb,
                    L.mb,
                    A(k, k), A.nb,
                    IPIV(k, k), &iinfo);
                if (PLASMA_INFO == 0 && iinfo > 0 && m == A.mt-1)
                    PLASMA_INFO = iinfo + A.nb*k;
                ss_cond_set(k, k, k);
            }
            else {
                ss_cond_wait(m, k, k-1);
                CORE_ztstrf(
                    m == A.mt-1 ? A.m-m*A.nb : A.nb,
                    k == A.nt-1 ? A.n-k*A.nb : A.nb,
                    L.mb,
                    A.nb,
                    A(k, k), A.nb,
                    A(m, k), A.nb,
                    L(m, k), L.mb,
                    IPIV(m, k), 
                    work, L.nb, &iinfo);
                if (PLASMA_INFO == 0 && iinfo > 0 && m == A.mt-1)
                    PLASMA_INFO = iinfo + A.nb*k;
                ss_cond_set(m, k, k);
            }
        }
        else {
            if (m == k) {
                ss_cond_wait(k, k, k);
                ss_cond_wait(k, n, k-1);
                CORE_zgessm(
                    k == A.mt-1 ? A.m-k*A.nb : A.nb,
                    n == A.nt-1 ? A.n-n*A.nb : A.nb,
                    A.nb,
                    L.mb,
                    IPIV(k, k),
                    A(k, k), A.nb,
                    A(k, n), A.nb);
            }
            else {
                ss_cond_wait(m, k, k);
                ss_cond_wait(m, n, k-1);
                CORE_zssssm(
                    A.nb,
                    m == A.mt-1 ? A.m-m*A.nb : A.nb,
                    n == A.nt-1 ? A.n-n*A.nb : A.nb,
                    L.mb,
                    A.nb,
                    A(k, n), A.nb,
                    A(m, n), A.nb,
                    L(m, k), L.mb,
                    A(m, k), A.nb,
                    IPIV(m, k));
                ss_cond_set(m, n, k);
            }
        }
        n = next_n;
        m = next_m;
        k = next_k;
    }
    plasma_private_free(plasma, work);
    ss_finalize();
}
