/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak, Hatem Ltaief                                 ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Parallel tile LQ factorization
#define A(m,n) &((PLASMA_Complex64_t*)A.mat)[A.bsiz*(m)+A.bsiz*A.lmt*(n)]
#define T(m,n) &((PLASMA_Complex64_t*)T.mat)[T.bsiz*(m)+T.bsiz*T.lmt*(n)]
void plasma_pzgelqf(plasma_context_t *plasma)
{
    PLASMA_desc A;
    PLASMA_desc T;

    int k, m, n;
    int next_k;
    int next_m;
    int next_n;
    PLASMA_Complex64_t *work, *tau;

    plasma_unpack_args_2(A, T);
    work = (PLASMA_Complex64_t *)plasma_private_alloc(plasma, T.mb*T.nb, T.dtyp);
    tau = (PLASMA_Complex64_t *)plasma_private_alloc(plasma, A.nb, A.dtyp);
    ss_init(A.mt, A.nt, -1);

    k = 0;
    m = PLASMA_RANK;
    while (m >= A.mt) {
        k++;
        m = m-A.mt+k;
    }
    n = k;

    while (k < min(A.nt, A.mt) && m < A.mt) {
        next_m = m;
        next_n = n;
        next_k = k;

        next_n++;
        if (next_n == A.nt) {
            next_m += PLASMA_SIZE;
            while (next_m >= A.mt && next_k < min(A.nt, A.mt)) {
                next_k++;
                next_m = next_m-A.mt+next_k;
            }
            next_n = next_k;
        }

        if (m == k) {
            if (n == k) {
                ss_cond_wait(k, k, k-1);
                CORE_zgelqt(
                    k == A.mt-1 ? A.m-k*A.nb : A.nb,
                    k == A.nt-1 ? A.n-k*A.nb : A.nb,
                    T.mb,
                    A(k, k), A.nb,
                    T(k, k), T.mb,
                    tau, work);
                ss_cond_set(k, k, k);
            }
            else {
                ss_cond_wait(k, n, k-1);
                CORE_ztslqt(
                    k == A.mt-1 ? A.m-k*A.nb : A.nb,
                    n == A.nt-1 ? A.n-n*A.nb : A.nb,
                    T.mb,
                    A(k, k), A.nb,
                    A(k, n), A.nb,
                    T(k, n), T.mb,
                    tau, work);
                ss_cond_set(k, n, k);
            }
        }
        else {
            if (n == k) {
                ss_cond_wait(k, k, k);
                ss_cond_wait(m, k, k-1);
                CORE_zunmlq(
                    PlasmaRight, PlasmaConjTrans,
                    m == A.mt-1 ? A.m-m*A.nb : A.nb,
                    k == A.nt-1 ? A.n-k*A.nb : A.nb,
                    T.mb,
                    k == A.nt-1 ? A.n-k*A.nb : A.nb,
                    A(k, k), A.nb,
                    T(k, k), T.mb,
                    A(m, k), A.nb,
                    work, T.nb);
            }
            else {
                ss_cond_wait(k, n, k);
                ss_cond_wait(m, n, k-1);
                CORE_zssmlq(
                    PlasmaRight, PlasmaConjTrans,
                    A.nb,
                    n == A.nt-1 ? A.n-n*A.nb : A.nb,
                    m == A.mt-1 ? A.m-m*A.nb : A.nb,
                    T.mb,
                    A.nb,
                    A(m, k), A.nb,
                    A(m, n), A.nb,
                    A(k, n), A.nb,
                    T(k, n), T.mb,
                    work, T.nb);
                ss_cond_set(m, n, k);
            }
        }
        m = next_m;
        n = next_n;
        k = next_k;
    }
    plasma_private_free(plasma, work);
    plasma_private_free(plasma, tau);
    ss_finalize();
}
