/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Hatem Ltaief, Jakub Kurzak                                 ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Parallel construction of Q using tile V (application to identity)
#define A(m,n) &((float*)A.mat)[A.bsiz*(m)+A.bsiz*A.lmt*(n)]
#define Q(m,n) &((float*)Q.mat)[Q.bsiz*(m)+Q.bsiz*Q.lmt*(n)]
#define T(m,n) &((float*)T.mat)[T.bsiz*(m)+T.bsiz*T.lmt*(n)]
void plasma_psorgqr(plasma_context_t *plasma)
{
    PLASMA_desc A;
    PLASMA_desc Q;
    PLASMA_desc T;

    int k, m, n;
    float *work;

    // Currently sequential
    if (PLASMA_RANK > 0) return;

    plasma_unpack_args_3(A, Q, T);
    work = (float *)plasma_private_alloc(plasma, T.mb*T.nb, T.dtyp);


    for (k = A.nt - 1; k >= 0; k--) {
        for (m = Q.mt - 1; m > k; m--) {
            for (n = 0; n < Q.nt; n++) {
                CORE_sssmqr(
                    PlasmaLeft, PlasmaNoTrans,
                    A.nb,
                    m == Q.mt-1 ? Q.m-m*Q.nb : Q.nb,
                    n == Q.nt-1 ? Q.n-n*Q.nb : Q.nb,
                    T.mb,
                    k == A.nt-1 ? A.n-k*A.nb : A.nb,
                    Q(k, n), Q.nb,
                    Q(m, n), Q.nb,
                    A(m, k), A.nb,
                    T(m, k), T.mb,
                    work, T.mb);
            }
        }
        for (n = 0; n < Q.nt; n++) {
            CORE_sormqr(
                PlasmaLeft, PlasmaNoTrans,
                k == A.mt-1 ? A.m-k*A.nb : A.nb,
                n == Q.nt-1 ? Q.n-n*Q.nb : Q.nb,
                T.mb,
                k == A.nt-1 ? min(A.m, A.n)-k*A.nb : A.nb,
                A(k, k), A.nb,
                T(k, k), T.mb,
                Q(k, n), Q.nb,
                work, T.nb);
        }
    }
    plasma_private_free(plasma, work);
}
