/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"
#include "lapack.h"

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#define B(m,n) &((double*)B.mat)[B.bsiz*(m)+B.bsiz*B.lmt*(n)]
#define SA(m,n) &((float*)SA.mat)[SA.bsiz*(m)+SA.bsiz*SA.lmt*(n)]

void plasma_pslag2d(plasma_context_t *plasma)
{
    PLASMA_desc SA;
    PLASMA_desc B;

    int info;
    int X, X1, X2, Y, Y1, Y2;
    int m, n;
    int next_m;
    int next_n;

    plasma_unpack_args_2(SA, B);

    n = 0;
    m = PLASMA_RANK;
    while (m >= SA.mt && n < SA.nt) {
        n++;
        m = m-SA.mt;
    }

    while (n < SA.nt) {
        next_m = m;
        next_n = n;

        next_m += PLASMA_SIZE;
        while (next_m >= SA.mt && next_n < SA.nt) {
            next_n++;
            next_m = next_m-SA.mt;
        }

        X1 = m == 0 ? SA.i%SA.nb : 0;
        Y1 = n == 0 ? SA.j%SA.nb : 0;
        X2 = m == SA.mt-1 ? (SA.i+SA.m-1)%SA.nb+1 : SA.nb;
        Y2 = n == SA.nt-1 ? (SA.j+SA.n-1)%SA.nb+1 : SA.nb;
        X = X2 - X1;
        Y = Y2 - Y1;

        slag2d(&X, &Y, SA(m,n), &SA.nb, B(m,n), &SA.nb, &info );

        m = next_m;
        n = next_n;
    }
}
