/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak, Hatem Ltaief                                 ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Parallel tile QR factorization
#define A(m,n) &((float*)A.mat)[A.bsiz*(m)+A.bsiz*A.lmt*(n)]
#define T(m,n) &((float*)T.mat)[T.bsiz*(m)+T.bsiz*T.lmt*(n)]
void plasma_psgeqrf(plasma_context_t *plasma)
{
    PLASMA_desc A;
    PLASMA_desc T;

    int k, m, n;
    int next_k;
    int next_m;
    int next_n;
    float *work, *tau;

    plasma_unpack_args_2(A, T);
    work = (float *)plasma_private_alloc(plasma, T.mb*T.nb, T.dtyp);
    tau = (float *)plasma_private_alloc(plasma, A.nb, A.dtyp);
    ss_init(A.mt, A.nt, -1);

    k = 0;
    n = PLASMA_RANK;
    while (n >= A.nt) {
        k++;
        n = n-A.nt+k;
    }
    m = k;

    while (k < min(A.mt, A.nt) && n < A.nt) {
        next_n = n;
        next_m = m;
        next_k = k;

        next_m++;
        if (next_m == A.mt) {
            next_n += PLASMA_SIZE;
            while (next_n >= A.nt && next_k < min(A.mt, A.nt)) {
                next_k++;
                next_n = next_n-A.nt+next_k;
            }
            next_m = next_k;
        }

        if (n == k) {
            if (m == k) {
                ss_cond_wait(k, k, k-1);
                CORE_sgeqrt(
                    k == A.mt-1 ? A.m-k*A.nb : A.nb,
                    k == A.nt-1 ? A.n-k*A.nb : A.nb,
                    T.mb,
                    A(k, k), A.nb,
                    T(k, k), T.mb,
                    tau, work);
                ss_cond_set(k, k, k);
            }
            else {
                ss_cond_wait(m, k, k-1);
                CORE_stsqrt(
                    m == A.mt-1 ? A.m-m*A.nb : A.nb,
                    k == A.nt-1 ? A.n-k*A.nb : A.nb,
                    T.mb,
                    A(k, k), A.nb,
                    A(m, k), A.nb,
                    T(m, k), T.mb,
                    tau, work);
                ss_cond_set(m, k, k);
            }
        }
        else {
            if (m == k) {
                ss_cond_wait(k, k, k);
                ss_cond_wait(k, n, k-1);
                CORE_sormqr(
                    PlasmaLeft, PlasmaTrans,
                    k == A.mt-1 ? A.m-k*A.nb : A.nb,
                    n == A.nt-1 ? A.n-n*A.nb : A.nb,
                    T.mb,
                    k == A.mt-1 ? A.m-k*A.nb : A.nb,
                    A(k, k), A.nb,
                    T(k, k), T.mb,
                    A(k, n), A.nb,
                    work, T.nb);
            }
            else {
                ss_cond_wait(m, k, k);
                ss_cond_wait(m, n, k-1);
                CORE_sssmqr(
                    PlasmaLeft, PlasmaTrans,
                    A.nb,
                    m == A.mt-1 ? A.m-m*A.nb : A.nb,
                    n == A.nt-1 ? A.n-n*A.nb : A.nb,
                    T.mb,
                    A.nb,
                    A(k, n), A.nb,
                    A(m, n), A.nb,
                    A(m, k), A.nb,
                    T(m, k), T.mb,
                    work, T.mb);
                ss_cond_set(m, n, k);
            }
        }
        n = next_n;
        m = next_m;
        k = next_k;
    }
    plasma_private_free(plasma, work);
    plasma_private_free(plasma, tau);
    ss_finalize();
}
