/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Bilel Hadri                                                ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"

#ifdef ADD_
    #define PLASMA_SGELQF       plasma_sgelqf_
    #define PLASMA_SGELQS       plasma_sgelqs_
    #define PLASMA_SGELS        plasma_sgels_
    #define PLASMA_SGEQRF       plasma_sgeqrf_
    #define PLASMA_SGEQRS       plasma_sgeqrs_
    #define PLASMA_SGESV        plasma_sgesv_
    #define PLASMA_SGETRF       plasma_sgetrf_
    #define PLASMA_SGETRS       plasma_sgetrs_
    #define PLASMA_SPOSV        plasma_sposv_
    #define PLASMA_SPOTRF       plasma_spotrf_
    #define PLASMA_SPOTRS       plasma_spotrs_
    #define PLASMA_STRSM        plasma_strsm_
    #define PLASMA_STRSMPL      plasma_strsmpl_
    #define PLASMA_SORGLQ       plasma_sorglq_
    #define PLASMA_SORGQR       plasma_sorgqr_
    #define PLASMA_SORMLQ       plasma_sormlq_
    #define PLASMA_SORMQR       plasma_sormqr_
    #define PLASMA_SGEMM        plasma_sgemm_

    #define PLASMA_SGELQF_TILE      plasma_sgelqf_tile_
    #define PLASMA_SGELQS_TILE      plasma_sgelqs_tile_
    #define PLASMA_SGELS_TILE       plasma_sgels_tile_
    #define PLASMA_SGEQRF_TILE      plasma_sgeqrf_tile_
    #define PLASMA_SGEQRS_TILE      plasma_sgeqrs_tile_
    #define PLASMA_SGESV_TILE       plasma_sgesv_tile_
    #define PLASMA_SGETRF_TILE      plasma_sgetrf_tile_
    #define PLASMA_SGETRS_TILE      plasma_sgetrs_tile_
    #define PLASMA_SPOSV_TILE       plasma_sposv_tile_
    #define PLASMA_SPOTRF_TILE      plasma_spotrf_tile_
    #define PLASMA_SPOTRS_TILE      plasma_spotrs_tile_
    #define PLASMA_STRSM_TILE       plasma_strsm_tile_
    #define PLASMA_STRSMPL_TILE     plasma_strsmpl_tile_
    #define PLASMA_SORGLQ_TILE      plasma_sorglq_tile_
    #define PLASMA_SORGQR_TILE      plasma_sorgqr_tile_
    #define PLASMA_SORMLQ_TILE      plasma_sormlq_tile_
    #define PLASMA_SORMQR_TILE      plasma_sormqr_tile_
    #define PLASMA_SGEMM_TILE       plasma_sgemm_tile_

    #define PLASMA_ALLOC_WORKSPACE_SGELQF       plasma_alloc_workspace_sgelqf_
    #define PLASMA_ALLOC_WORKSPACE_SGELS        plasma_alloc_workspace_sgels_
    #define PLASMA_ALLOC_WORKSPACE_SGEQRF       plasma_alloc_workspace_sgeqrf_
    #define PLASMA_ALLOC_WORKSPACE_SGESV        plasma_alloc_workspace_sgesv_
    #define PLASMA_ALLOC_WORKSPACE_SGETRF       plasma_alloc_workspace_sgetrf_
    #define PLASMA_ALLOC_WORKSPACE_SGELQF       plasma_alloc_workspace_sgelqf_
#elif defined (NOCHANGE)
    #define PLASMA_SGELQF       plasma_sgelqf
    #define PLASMA_SGELQS       plasma_sgelqs
    #define PLASMA_SGELS        plasma_sgels
    #define PLASMA_SGEQRF       plasma_sgeqrf
    #define PLASMA_SGEQRS       plasma_sgeqrs
    #define PLASMA_SGESV        plasma_sgesv
    #define PLASMA_SGETRF       plasma_sgetrf
    #define PLASMA_SGETRS       plasma_sgetrs
    #define PLASMA_SPOSV        plasma_sposv
    #define PLASMA_SPOTRF       plasma_spotrf
    #define PLASMA_SPOTRS       plasma_spotrs
    #define PLASMA_STRSM        plasma_strsm
    #define PLASMA_STRSMPL      plasma_strsmpl
    #define PLASMA_SORGLQ       plasma_sorglq
    #define PLASMA_SORGQR       plasma_sorgqr
    #define PLASMA_SORMLQ       plasma_sormlq
    #define PLASMA_SORMQR       plasma_sormqr
    #define PLASMA_SGEMM        plasma_sgemm

    #define PLASMA_SGELQF_TILE      plasma_sgelqf_tile
    #define PLASMA_SGELQS_TILE      plasma_sgelqs_tile
    #define PLASMA_SGELS_TILE       plasma_sgels_tile
    #define PLASMA_SGEQRF_TILE      plasma_sgeqrf_tile
    #define PLASMA_SGEQRS_TILE      plasma_sgeqrs_tile
    #define PLASMA_SGESV_TILE       plasma_sgesv_tile
    #define PLASMA_SGETRF_TILE      plasma_sgetrf_tile
    #define PLASMA_SGETRS_TILE      plasma_sgetrs_tile
    #define PLASMA_SPOSV_TILE       plasma_sposv_tile
    #define PLASMA_SPOTRF_TILE      plasma_spotrf_tile
    #define PLASMA_SPOTRS_TILE      plasma_spotrs_tile
    #define PLASMA_STRSM_TILE       plasma_strsm_tile
    #define PLASMA_STRSMPL_TILE     plasma_strsmpl_tile
    #define PLASMA_SORGLQ_TILE      plasma_sorglq_tile
    #define PLASMA_SORGQR_TILE      plasma_sorgqr_tile
    #define PLASMA_SORMLQ_TILE      plasma_sormlq_tile
    #define PLASMA_SORMQR_TILE      plasma_sormqr_tile
    #define PLASMA_SGEMM_TILE       plasma_sgemm_tile

    #define PLASMA_ALLOC_WORKSPACE_SGELQF       plasma_alloc_workspace_sgelqf
    #define PLASMA_ALLOC_WORKSPACE_SGELS        plasma_alloc_workspace_sgels
    #define PLASMA_ALLOC_WORKSPACE_SGEQRF       plasma_alloc_workspace_sgeqrf
    #define PLASMA_ALLOC_WORKSPACE_SGESV        plasma_alloc_workspace_sgesv
    #define PLASMA_ALLOC_WORKSPACE_SGETRF       plasma_alloc_workspace_sgetrf
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  FORTRAN API - math functions
void PLASMA_SGELQF(int *M, int *N, float *A, int *LDA, float **T, int *INFO)
{   *INFO = PLASMA_sgelqf(*M, *N, A, *LDA, *T); }

void PLASMA_SGELQS(int *M, int *N, int *NRHS, float *A, int *LDA, float **T, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sgelqs(*M, *N, *NRHS, A, *LDA, *T, B, *LDB); }

void PLASMA_SGELS(PLASMA_enum *trans, int *M, int *N, int *NRHS, float *A, int *LDA, float **T, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sgels(*trans, *M, *N, *NRHS, A, *LDA, *T, B, *LDB); }

void PLASMA_SGEQRF(int *M, int *N, float *A, int *LDA, float **T, int *INFO)
{   *INFO = PLASMA_sgeqrf(*M, *N, A, *LDA, *T); }

void PLASMA_SGEQRS(int *M, int *N, int *NRHS, float *A, int *LDA, float **T, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sgeqrs(*M, *N, *NRHS, A, *LDA, *T, B, *LDB); }

void PLASMA_SGESV(int *N, int *NRHS, float *A, int *LDA, float **LH, int **IPIVH, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sgesv(*N, *NRHS, A, *LDA, *LH, *IPIVH, B, *LDB); }

void PLASMA_SGETRF(int *M, int *N, float *A, int *LDA, float **LH, int **IPIVH, int *INFO)
{   *INFO = PLASMA_sgetrf(*M, *N, A, *LDA, *LH, *IPIVH); }

void PLASMA_SGETRS(PLASMA_enum *uplo, int *N, int *NRHS, float *A, int *LDA, float **LH, int **IPIVH, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sgetrs(*uplo, *N, *NRHS, A, *LDA, *LH, *IPIVH, B, *LDB); }

void PLASMA_SPOSV(PLASMA_enum *uplo, int *N, int *NRHS, float *A, int *LDA, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sposv(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_SPOTRF(PLASMA_enum *uplo, int *N, float *A, int *LDA, int *INFO)
{   *INFO = PLASMA_spotrf(*uplo, *N, A, *LDA); }

void PLASMA_SPOTRS(PLASMA_enum *uplo, int *N, int *NRHS, float *A, int *LDA, float *B, int* LDB, int * INFO)
{   *INFO = PLASMA_spotrs(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_STRSM(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, float *A, int *LDA, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_strsm(*side, *uplo, *transA, *diag, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_STRSMPL(int *N, int *NRHS, float *A, int *LDA, float **LH, int **IPIVH, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_strsmpl(*N, *NRHS, A, *LDA, *LH, *IPIVH, B, *LDB); }

void PLASMA_SORGLQ(int *M, int *N, int *K, float *A, int *LDA, float **T, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sorglq(*M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_SORGQR(int *M, int *N, int *K, float *A, int *LDA, float **T, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sorgqr(*M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_SORMLQ(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, float *A, int *LDA, float **T, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sormlq(*side, *trans, *M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_SORMQR(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, float *A, int *LDA, float **T, float *B, int *LDB, int *INFO)
{   *INFO = PLASMA_sormqr(*side, *trans, *M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_SGEMM(PLASMA_enum *transA, PLASMA_enum *transB, int *M, int *N, int *K, float *alpha, float *A, int *LDA, float *B, int *LDB, float *beta, float *C, int *LDC, int *INFO)
{   *INFO = PLASMA_sgemm(*transA, *transB, *M, *N, *K, *alpha, A, *LDA, B, *LDB, *beta, C, *LDC); }


/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Math functions - native interface
void PLASMA_SGELQF_TILE(long long int *A, long long int *T,int *INFO)
{   *INFO = PLASMA_sgelqf_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T)); }

void PLASMA_SGELQS_TILE(long long int *A, long long int *B, long long int *T, int *INFO)
{   *INFO = PLASMA_sgelqs_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T)); }

void PLASMA_SGELS_TILE(PLASMA_enum *trans, long long int *A, long long int *B, long long int *T, int *INFO)
{   *INFO = PLASMA_sgels_Tile(*trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T)); }

void PLASMA_SGEQRF_TILE(long long int *A, long long int *T, int *INFO)
{   *INFO = PLASMA_sgeqrf_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T)); }

void PLASMA_SGEQRS_TILE(long long int *A, long long int *B, long long int *T, int *INFO)
{   *INFO = PLASMA_sgeqrs_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T)); }

void PLASMA_SGESV_TILE(long long int *A, long long int *L, int **IPIVH, long long int *B, int *INFO)
{   *INFO = PLASMA_sgesv_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B)); }

void PLASMA_SGETRF_TILE(long long int *A, long long int *L, int **IPIVH, int *INFO)
{   *INFO = PLASMA_sgetrf_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH); }

void PLASMA_SGETRS_TILE(long long int *A, long long int *L, int **IPIVH, long long int *B, int *INFO)
{   *INFO = PLASMA_sgetrs_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B)); }

void PLASMA_SPOSV_TILE(PLASMA_enum *uplo, long long int *A, long long int *B, int *INFO)
{   *INFO = PLASMA_sposv_Tile(*uplo, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B)); }

void PLASMA_SPOTRF_TILE(PLASMA_enum *uplo, long long int *A, int *INFO)
{   *INFO = PLASMA_spotrf_Tile(*uplo, (PLASMA_desc *)(*A)); }

void PLASMA_SPOTRS_TILE(PLASMA_enum *uplo, long long int *A, long long int *B, int *INFO)
{   *INFO = PLASMA_spotrs_Tile(*uplo, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B)); }

void PLASMA_STRSM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, long long int *A, long long int *B, int *INFO)
{   *INFO = PLASMA_strsm_Tile(*side, *uplo, *transA, *diag, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B)); }

void PLASMA_STRSMPL_TILE(long long int *A, long long int *L, int **IPIVH, long long int *B, int *INFO)
{   *INFO = PLASMA_strsmpl_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B)); }

void PLASMA_SUNQLQ_TILE(long long int *A, long long int *T, long long int *B, int *INFO)
{   *INFO = PLASMA_sorglq_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_SORGQR_TILE(long long int *A, long long int *T, long long int *B, int *INFO)
{   *INFO = PLASMA_sorgqr_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_SORMLQ_TILE(PLASMA_enum *side, PLASMA_enum *trans, long long int *A, long long int *T, long long int *B, int *INFO)
{   *INFO = PLASMA_sormlq_Tile(*side, *trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_SORMQR_TILE(PLASMA_enum *side, PLASMA_enum *trans, long long int *A, long long int *T, long long int *B, int *INFO)
{   *INFO = PLASMA_sormqr_Tile(*side, *trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

/* void PLASMA_SGEMM_TILE(PLASMA_enum *transA, PLASMA_enum *transB, int *alpha, long long int *A, long long int *B, int *beta, long long int *C, int *INFO)
{   *INFO = PLASMA_sgemm_Tile(*transA, *transB, *alpha, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), *beta, (PLASMA_desc *)(*C)); } */

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  FORTRAN API - workspace allocation
void PLASMA_ALLOC_WORKSPACE_SGELQF(int *M, int *N, float **T, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_sgelqf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_SGELS(int *M, int *N, float **T, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_sgels(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_SGEQRF(int *M, int *N, float **T, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_sgeqrf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_SGESV(int *N, float **L, int **IPIV, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_sgesv(*N, L, IPIV); }

void PLASMA_ALLOC_WORKSPACE_SGETRF(int *M, int *N, float **L, int **IPIV, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_sgetrf(*M, *N, L, IPIV); }

#ifdef __cplusplus
}
#endif
