/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Bilel Hadri                                                ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"

#ifdef ADD_
    #define PLASMA_ZCGESV           plasma_zcgesv_
    #define PLASMA_DSGESV           plasma_dsgesv_

    #define PLASMA_ZCGESV_TILE       plasma_zcgesv_tile_
    #define PLASMA_DSGESV_TILE       plasma_dsgesv_tile_
#elif defined (NOCHANGE)
    #define PLASMA_ZCGESV           plasma_zcgesv
    #define PLASMA_DSGESV           plasma_dsgesv

    #define PLASMA_ZCGESV_TILE       plasma_zcgesv_tile
    #define PLASMA_DSGESV_TILE       plasma_dsgesv_tile
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  FORTRAN API - math functions
void PLASMA_ZCGESV(int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, PLASMA_Complex64_t *X, int *LDX, int *ITER, int *INFO)
{   *INFO = PLASMA_zcgesv(*N, *NRHS, A, *LDA, B, *LDB, X, *LDX, ITER); }

void PLASMA_DSGESV(int *N, int *NRHS, double *A, int *LDA, double *B, int *LDB, double *X, int *LDX, int *ITER, int *INFO)
{   *INFO = PLASMA_dsgesv(*N, *NRHS, A, *LDA, B, *LDB, X, *LDX, ITER); }

#ifdef __cplusplus
}
#endif

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Math functions - native interface

void PLASMA_ZCGESV_TILE(long long int *A, long long int *L, int **IPIVH, long long int *B, long long *X, int *ITER, int *INFO)
{   *INFO = PLASMA_zcgesv_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B), (PLASMA_desc *)(*X), ITER); }

void PLASMA_DSGESV_TILE(long long int *A, long long int *L, int **IPIVH, long long int *B, long long *X, int *ITER, int *INFO)
{   *INFO = PLASMA_zcgesv_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B), (PLASMA_desc *)(*X), ITER); }
