/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"
#include "lapack.h"

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#define A(m,n) &((double*)A.mat)[A.bsiz*(m)+A.bsiz*A.lmt*(n)]
#define SB(m,n) &((PLASMA_Complex32_t*)SB.mat)[SB.bsiz*(m)+SB.bsiz*SB.lmt*(n)]

void plasma_pdlag2c(plasma_context_t *plasma)
{
    PLASMA_desc A;
    PLASMA_desc SB;

    int info;
    int X, X1, X2, Y, Y1, Y2;
    int m, n;
    int next_m;
    int next_n;

    plasma_unpack_args_2(A, SB);

    n = 0;
    m = PLASMA_RANK;
    while (m >= A.mt && n < A.nt) {
        n++;
        m = m-A.mt;
    }

    while (n < A.nt) {
        next_m = m;
        next_n = n;

        next_m += PLASMA_SIZE;
        while (next_m >= A.mt && next_n < A.nt) {
            next_n++;
            next_m = next_m-A.mt;
        }

        X1 = m == 0 ? A.i%A.nb : 0;
        Y1 = n == 0 ? A.j%A.nb : 0;
        X2 = m == A.mt-1 ? (A.i+A.m-1)%A.nb+1 : A.nb;
        Y2 = n == A.nt-1 ? (A.j+A.n-1)%A.nb+1 : A.nb;
        X = X2 - X1;
        Y = Y2 - Y1;

        zlag2c(&X, &Y, A(m,n), &A.nb, SB(m,n), &A.nb, &info);

        m = next_m;
        n = next_n;
    }
}

