/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Hatem Ltaief, Jakub Kurzak                                 ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Parallel construction of Q using tile V (application to identity)
#define A(m,n) &((PLASMA_Complex32_t*)A.mat)[A.bsiz*(m)+A.bsiz*A.lmt*(n)]
#define Q(m,n) &((PLASMA_Complex32_t*)Q.mat)[Q.bsiz*(m)+Q.bsiz*Q.lmt*(n)]
#define T(m,n) &((PLASMA_Complex32_t*)T.mat)[T.bsiz*(m)+T.bsiz*T.lmt*(n)]
void plasma_pcunglq(plasma_context_t *plasma)
{
    PLASMA_desc A;
    PLASMA_desc Q;
    PLASMA_desc T;

    int k, m, n;
    PLASMA_Complex32_t *work;

    // Currently sequential
    if (PLASMA_RANK > 0) return;

    plasma_unpack_args_3(A, Q, T);
    work = (PLASMA_Complex32_t *)plasma_private_alloc(plasma, T.mb*T.nb, T.dtyp);

    for (k = min(A.mt, A.nt) - 1; k >= 0; k--) {
        for (n = Q.nt - 1; n > k; n--) {
            for (m = 0; m < Q.mt; m++) {
                CORE_cssmlq(
                    PlasmaRight, PlasmaNoTrans,
                    A.nb,
                    n == Q.nt-1 ? Q.n-n*Q.nb : Q.nb,
                    m == Q.mt-1 ? Q.m-m*Q.nb : Q.nb,
                    T.mb,
                    k == A.mt-1 ? A.m-k*A.nb : A.nb,
                    Q(m, k), Q.nb,
                    Q(m, n), Q.nb,
                    A(k, n), A.nb,
                    T(k, n), T.mb,
                    work, T.nb);
            }
        }
        for (m = 0; m < Q.mt; m++) {
            CORE_cunmlq(
                PlasmaRight, PlasmaNoTrans,
                m == Q.mt-1 ? Q.m-m*Q.nb : Q.nb,
                k == A.nt-1 ? A.n-k*A.nb : A.nb,
                T.mb,
                k == A.mt-1 ? min(A.m, A.n)-k*A.nb : A.nb,
                A(k, k), A.nb,
                T(k, k), T.mb,
                Q(m, k), Q.nb,
                work, T.nb);
        }
    }
    plasma_private_free(plasma, work);
}
