/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak, Hatem Ltaief                                 ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Parallel application of Q using tile V - QR factorization
#define A(m,n) &((PLASMA_Complex32_t*)A.mat)[A.bsiz*(m)+A.bsiz*A.lmt*(n)]
#define B(m,n) &((PLASMA_Complex32_t*)B.mat)[B.bsiz*(m)+B.bsiz*B.lmt*(n)]
#define L(m,n) &((PLASMA_Complex32_t*)L.mat)[L.bsiz*(m)+L.bsiz*L.lmt*(n)]
#define IPIV(m,n) &IPIV[A.nb*(m)+A.nb*A.lmt*(n)]
void plasma_pctrsmpl(plasma_context_t *plasma)
{
    PLASMA_desc A;
    PLASMA_desc B;
    PLASMA_desc L;
    int*        IPIV;

    int k, m, n;
    int next_k;
    int next_m;
    int next_n;

    plasma_unpack_args_4(A, B, L, IPIV);
    ss_init(B.mt, B.nt, -1);

    k = 0;
    n = PLASMA_RANK;
    while (n >= B.nt) {
        k++;
        n = n-B.nt;
    }
    m = k;

    while (k < min(A.mt, A.nt) && n < B.nt) {
        next_n = n;
        next_m = m;
        next_k = k;

        next_m++;
        if (next_m == A.mt) {
            next_n += PLASMA_SIZE;
            while (next_n >= B.nt && next_k < min(A.mt, A.nt)) {
                next_k++;
                next_n = next_n-B.nt;
            }
            next_m = next_k;
        }

        if (m == k) {
            ss_cond_wait(k, n, k-1);
            CORE_cgessm(
                k == A.mt-1 ? A.m-k*A.nb : A.nb,
                n == B.nt-1 ? B.n-n*B.nb : B.nb,
                k == A.nt-1 ? min(A.m-k*A.nb, A.n-k*A.nb) : A.nb,
                L.mb,
                IPIV(k, k),
                A(k, k), A.nb,
                B(k, n), B.nb);
            ss_cond_set(k, n, k);
        }
        else {
            ss_cond_wait(m, n, k-1);
            CORE_cssssm(
                A.nb,
                m == A.mt-1 ? A.m-m*A.nb : A.nb,
                n == B.nt-1 ? B.n-n*A.nb : B.nb,
                L.mb,
                k == A.nt-1 ? A.n-k*A.nb : A.nb,
                B(k, n), B.nb,
                B(m, n), B.nb,
                L(m, k), L.mb,
                A(m, k), A.nb,
                IPIV(m, k));
            ss_cond_set(m, n, k);
        }
        n = next_n;
        m = next_m;
        k = next_k;
    }
    ss_finalize();
}
