/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak, Hatem Ltaief                                 ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Parallel Cholesky factorization
#define A(m,n) &((PLASMA_Complex32_t*)A.mat)[A.bsiz*(m)+A.bsiz*A.lmt*(n)]
void plasma_pcpotrf(plasma_context_t *plasma)
{
    PLASMA_enum uplo;
    PLASMA_desc A;

    int k, m, n;
    int next_k;
    int next_m;
    int next_n;

    plasma_unpack_args_2(uplo, A);
    ss_init(A.nt, A.nt, 0);

    k = 0;
    m = PLASMA_RANK;
    while (m >= A.nt) {
        k++;
        m = m-A.nt+k;
    }
    n = 0;

    while (k < A.nt && m < A.nt && !ss_aborted()) {
        next_n = n;
        next_m = m;
        next_k = k;

        next_n++;
        if (next_n > next_k) {
            next_m += PLASMA_SIZE;
            while (next_m >= A.nt && next_k < A.nt) {
                next_k++;
                next_m = next_m-A.nt+next_k;
            }
            next_n = 0;
        }

        if (m == k) {
            if (n == k) {
                if (uplo == PlasmaLower)
                    CORE_cpotrf(
                        PlasmaLower,
                        k == A.nt-1 ? A.n-k*A.nb : A.nb,
                        A(k, k), A.nb,
                        &PLASMA_INFO);
                else
                    CORE_cpotrf(
                        PlasmaUpper,
                        k == A.nt-1 ? A.n-k*A.nb : A.nb,
                        A(k, k), A.nb,
                        &PLASMA_INFO);
                if (PLASMA_INFO != 0) {
                    PLASMA_INFO += A.nb*k;
                    ss_abort();
                }
                ss_cond_set(k, k, 1);
            }
            else {
                ss_cond_wait(k, n, 1);
                if (uplo == PlasmaLower)
                    CORE_cherk(
                         PlasmaLower, PlasmaNoTrans,
                         k == A.nt-1 ? A.n-k*A.nb : A.nb,
                         A.nb,
                        -1.0, A(k, n), A.nb,
                         1.0, A(k, k), A.nb);
                else
                    CORE_cherk(
                         PlasmaUpper, PlasmaConjTrans,
                         k == A.nt-1 ? A.n-k*A.nb : A.nb,
                         A.nb,
                        -1.0, A(n, k), A.nb,
                         1.0, A(k, k), A.nb);
            }
        }
        else {
            if (n == k) {
                ss_cond_wait(k, k, 1);
                if (uplo == PlasmaLower)
                    CORE_ctrsm(
                        PlasmaRight, PlasmaLower, PlasmaConjTrans, PlasmaNonUnit,
                        m == A.nt-1 ? A.n-m*A.nb : A.nb,
                        A.nb,
                        1.0, A(k, k), A.nb,
                             A(m, k), A.nb);
                else
                    CORE_ctrsm(
                        PlasmaLeft, PlasmaUpper, PlasmaConjTrans, PlasmaNonUnit,
                        A.nb,
                        m == A.nt-1 ? A.n-m*A.nb : A.nb,
                        1.0, A(k, k), A.nb,
                             A(k, m), A.nb);
                ss_cond_set(m, k, 1);
            }
            else {
                ss_cond_wait(k, n, 1);
                ss_cond_wait(m, n, 1);
                if (uplo == PlasmaLower)
                    CORE_cgemm(
                        PlasmaNoTrans, PlasmaConjTrans,
                        m == A.nt-1 ? A.n-m*A.nb : A.nb,
                        A.nb,
                        A.nb,
                       -1.0, A(m, n), A.nb,
                             A(k, n), A.nb,
                        1.0, A(m, k), A.nb);
                else
                    CORE_cgemm(
                        PlasmaConjTrans, PlasmaNoTrans,
                        A.nb,
                        m == A.nt-1 ? A.n-m*A.nb : A.nb,
                        A.nb,
                       -1.0, A(n, k), A.nb,
                             A(n, m), A.nb,
                        1.0, A(k, m), A.nb);
            }
        }
        n = next_n;
        m = next_m;
        k = next_k;
    }
    ss_finalize();
}
