/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak, Hatem Ltaief                                 ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#ifndef _PLASMA_CORE_SBLAS_H_
#define _PLASMA_CORE_SBLAS_H_

#ifdef ADD_
    #define spotrf spotrf_
    #define core_sgeqrt core_sgeqrt_
    #define core_stsqrt core_stsqrt_
    #define core_sormqr core_sormqr_
    #define core_sormlq core_sormlq_
    #define core_sssrfb core_sssrfb_
    #define core_sssmqr core_sssmqr_
    #define core_sssmlq core_sssmlq_
    #define core_sgelqt core_sgelqt_
    #define core_stslqt core_stslqt_
    #define core_sgetrf core_sgetrf_
    #define core_ststrf core_ststrf_
    #define core_sgessm core_sgessm_
    #define core_sssssm core_sssssm_
#endif

#ifdef UPCASE
    #define spotrf SPOTRF
    #define core_sgeqrt CORE_SGEQRT
    #define core_stsqrt CORE_STSQRT
    #define core_sormqr CORE_SORMQR
    #define core_sormlq CORE_SORMLQ
    #define core_sssrfb CORE_SSSRFB
    #define core_sssmqr CORE_SSSMQR
    #define core_sssmlq CORE_SSSMLQ
    #define core_sgelqt CORE_SGELQT
    #define core_stslqt CORE_STSLQT
    #define core_sgetrf CORE_SGETRF
    #define core_ststrf CORE_STSTRF
    #define core_sgessm CORE_SGESSM
    #define core_sssssm CORE_SSSSSM
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  FORTRAN prototypes
void spotrf(char*, int*, float*, int*, int*);
void core_sgeqrt(int*, int*, int*, float*, int*, float*, int*, float*, float*, int*);
void core_stsqrt(int*, int*, int*, float*, int*, float*, int*, float*, int*, float*, float*, int*);
void core_sormqr(char*, char*, int*, int*, int*, int*, float*, int*, float*, int*, float*, int*, float*, int*, int*);
void core_sormlq(char*, char*, int*, int*, int*, int*, float*, int*, float*, int*, float*, int*, float*, int*, int*);
void core_sssrfb(char*, char*, int*, int*, int*, int*, int*, float*, int*, float*, int*, float*, int*, float*, int*, float*, int*);
void core_sssmqr(char*, char*, int*, int*, int*, int*, int*, float*, int*, float*, int*, float*, int*, float*, int*, float*, int*, int*);
void core_sssmlq(char*, char*, int*, int*, int*, int*, int*, float*, int*, float*, int*, float*, int*, float*, int*, float*, int*, int*);
void core_sgelqt(int*, int*, int*, float*, int*, float*, int*, float*, float*, int*);
void core_stslqt(int*, int*, int*, float*, int*, float*, int*, float*, int*, float*, float*, int*);
void core_sgetrf(int*, int*, int*, float*, int*, int*, int*);
void core_ststrf(int*, int*, int*, int*, float*, int*, float*, int*, float*, int*, int *, float*, int*, int*);
void core_sgessm(int*, int*, int*, int*, int*, float*, int*, float*, int*, int*);
void core_sssssm(int*, int*, int*, int*, int*, float*, int*, float*, int*, float*, int*, float*, int*, int*, int*);

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  C prototypes
void CORE_sgelqt(int M, int N, int IB,
                 float *A, int LDA,
                 float *T, int LDT,
                 float *TAU, float *WORK);
void CORE_sgemm(int transA, int transB,
                int M, int N, int K,
                float alpha, float *A, int LDA,
                float *B, int LDB,
                float beta, float *C, int LDC);
void CORE_sgeqrt(int M, int N, int IB,
                 float *A, int LDA,
                 float *T, int LDT,
                 float *TAU, float *WORK);
void CORE_sgessm(int M, int N, int K, int IB,
                 int *IPIV,
                 float *L, int LDL,
                 float *A, int LDA);
void CORE_sgetrf(int M, int N, int IB,
                 float *A, int LDA,
                 int *IPIV, int *INFO);
void CORE_spotrf(int uplo, int N, float *A, int LDA, int *INFO);
void CORE_sssmlq(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 float *A1, int LDA1,
                 float *A2, int LDA2,
                 float *V, int LDV,
                 float *T, int LDT,
                 float *WORK, int LDWORK);
void CORE_sssmqr(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 float *A1, int LDA1,
                 float *A2, int LDA2,
                 float *V, int LDV,
                 float *T, int LDT,
                 float *WORK, int LDWORK);
void CORE_sssssm(int M1, int M2, int NN, int IB, int K,
                 float *A1, int LDA1,
                 float *A2, int LDA2,
                 float *L1, int LDL1,
                 float *L2, int LDL2,
                 int *IPIV);
void CORE_ssyrk(int uplo, int trans,
                int N, int K,
                float alpha, float *A, int LDA,
                float beta, float *C, int LDC);
void CORE_strsm(int side, int uplo,
                int transA, int diag,
                int M, int N,
                float alpha, float *A, int LDA,
                float *B, int LDB);
void CORE_stslqt(int M, int N, int IB,
                 float *A1, int LDA1,
                 float *A2, int LDA2,
                 float *T, int LDT,
                 float *TAU, float *WORK);
void CORE_stsqrt(int M, int N, int IB,
                 float *A1, int LDA1,
                 float *A2, int LDA2,
                 float *T, int LDT,
                 float *TAU, float *WORK);
void CORE_ststrf(int M, int N, int IB, int NB,
                 float *U, int LDU,
                 float *A, int LDA,
                 float *L, int LDL,
                 int *IPIV, float *WORK,
                 int LDWORK, int *INFO);
void CORE_sormlq(int side, int trans,
                 int M, int N, int IB, int K,
                 float *V, int LDV,
                 float *T, int LDT,
                 float *C, int LDC,
                 float *WORK, int LDWORK);
void CORE_sormqr(int side, int trans,
                 int M, int N, int IB, int K,
                 float *V, int LDV,
                 float *T, int LDT,
                 float *C, int LDC,
                 float *WORK, int LDWORK);

#ifdef __cplusplus
}
#endif

#endif
