/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak, Hatem Ltaief                                 ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"
#include "core_blas.h"
#include "lapack.h"

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_sgelqt(int M, int N, int IB,
                 float *A, int LDA,
                 float *T, int LDT,
                 float *TAU, float *WORK)
{
    int INFO;

    core_sgelqt(
        &M, &N, &IB,
        A, &LDA,
        T, &LDT,
        TAU, WORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_sgemm(int transA, int transB,
                int M, int N, int K,
                float alpha, float *A, int LDA,
                float *B, int LDB,
                float beta, float *C, int LDC)
{
    cblas_sgemm(
        CblasColMajor,
        (CBLAS_TRANSPOSE)transA, (CBLAS_TRANSPOSE)transB,
        M, N, K,
        (alpha), A, LDA,
        B, LDB,
        (beta), C, LDC);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_sgeqrt(int M, int N, int IB,
                 float *A, int LDA,
                 float *T, int LDT,
                 float *TAU, float *WORK)
{
    int INFO;

    core_sgeqrt(
        &M, &N, &IB,
        A, &LDA,
        T, &LDT,
        TAU, WORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_sgessm(int M, int N, int K, int IB,
                 int *IPIV,
                 float *L, int LDL,
                 float *A, int LDA)
{
    int INFO;

    core_sgessm(
        &M, &N, &K, &IB,
        IPIV,
        L, &LDL,
        A, &LDA,
        &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_sgetrf(int M, int N, int IB,
                 float *A, int LDA,
                 int *IPIV, int *INFO)
{
    core_sgetrf(
        &M, &N, &IB,
        A, &LDA,
        IPIV, INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_spotrf(int uplo, int N, float *A, int LDA, int *INFO)
{
    spotrf(lapack_const(uplo), &N, A, &LDA, INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_sssmlq(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 float *A1, int LDA1,
                 float *A2, int LDA2,
                 float *V, int LDV,
                 float *T, int LDT,
                 float *WORK, int LDWORK)
{
    int INFO;

    core_sssmlq(
        lapack_const(side), lapack_const(trans),
        &M1, &M2, &NN, &IB, &K,
        A1, &LDA1,
        A2, &LDA2,
        V, &LDV,
        T, &LDT,
        WORK, &LDWORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_sssmqr(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 float *A1, int LDA1,
                 float *A2, int LDA2,
                 float *V, int LDV,
                 float *T, int LDT,
                 float *WORK, int LDWORK)
{
    int INFO;

    core_sssmqr(
        lapack_const(side), lapack_const(trans),
        &M1, &M2, &NN, &IB, &K,
        A1, &LDA1,
        A2, &LDA2,
        V, &LDV,
        T, &LDT,
        WORK, &LDWORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_sssssm(int M1, int M2, int NN, int IB, int K,
                 float *A1, int LDA1,
                 float *A2, int LDA2,
                 float *L1, int LDL1,
                 float *L2, int LDL2,
                 int *IPIV)
{
    int INFO;

    core_sssssm(
        &M1, &M2, &NN, &IB, &K,
        A1, &LDA1,
        A2, &LDA2,
        L1, &LDL1,
        L2, &LDL2,
        IPIV,
        &INFO);
}
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_ssyrk(int uplo, int trans,
                int N, int K,
                float alpha, float *A, int LDA,
                float beta, float *C, int LDC)
{
    cblas_ssyrk(
        CblasColMajor,
        (CBLAS_UPLO)uplo, (CBLAS_TRANSPOSE)trans,
        N, K,
        (alpha), A, LDA,
        (beta), C, LDC);
}
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_strsm(int side, int uplo,
                int transA, int diag,
                int M, int N,
                float alpha, float *A, int LDA,
                float *B, int LDB)
{
    cblas_strsm(
        CblasColMajor,
        (CBLAS_SIDE)side, (CBLAS_UPLO)uplo,
        (CBLAS_TRANSPOSE)transA, (CBLAS_DIAG)diag,
        M, N,
        (alpha), A, LDA,
        B, LDB);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_stslqt(int M, int N, int IB,
                 float *A1, int LDA1,
                 float *A2, int LDA2,
                 float *T, int LDT,
                 float *TAU, float *WORK)
{
    int INFO;

    core_stslqt(
        &M, &N, &IB,
        A1, &LDA1,
        A2, &LDA2,
        T, &LDT,
        TAU, WORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_stsqrt(int M, int N, int IB,
                 float *A1, int LDA1,
                 float *A2, int LDA2,
                 float *T, int LDT,
                 float *TAU, float *WORK)
{
    int INFO;

    core_stsqrt(
        &M, &N, &IB,
        A1, &LDA1,
        A2, &LDA2,
        T, &LDT,
        TAU, WORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_ststrf(int M, int N, int IB, int NB,
                 float *U, int LDU,
                 float *A, int LDA,
                 float *L, int LDL,
                 int *IPIV, float *WORK,
                 int LDWORK, int *INFO)
{
    core_ststrf(
        &M, &N, &IB, &NB,
        U, &LDU,
        A, &LDA,
        L, &LDL,
        IPIV,
        WORK, &LDWORK, INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_sormlq(int side, int trans,
                 int M, int N, int IB, int K,
                 float *V, int LDV,
                 float *T, int LDT,
                 float *C, int LDC,
                 float *WORK, int LDWORK)
{
    int INFO;

    core_sormlq(
        lapack_const(side), lapack_const(trans),
        &M, &N, &IB, &K,
        V, &LDV,
        T, &LDT,
        C, &LDC,
        WORK, &LDWORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_sormqr(int side, int trans,
                 int M, int N, int IB, int K,
                 float *V, int LDV,
                 float *T, int LDT,
                 float *C, int LDC,
                 float *WORK, int LDWORK)
{
    int INFO;

    core_sormqr(
        lapack_const(side), lapack_const(trans),
        &M, &N, &IB, &K,
        V, &LDV,
        T, &LDT,
        C, &LDC,
        WORK, &LDWORK, &INFO);
}
