/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak, Hatem Ltaief                                 ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#ifndef _PLASMA_CORE_DBLAS_H_
#define _PLASMA_CORE_DBLAS_H_

#ifdef ADD_
    #define dpotrf dpotrf_
    #define core_dgeqrt core_dgeqrt_
    #define core_dtsqrt core_dtsqrt_
    #define core_dormqr core_dormqr_
    #define core_dormlq core_dormlq_
    #define core_dssrfb core_dssrfb_
    #define core_dssmqr core_dssmqr_
    #define core_dssmlq core_dssmlq_
    #define core_dgelqt core_dgelqt_
    #define core_dtslqt core_dtslqt_
    #define core_dgetrf core_dgetrf_
    #define core_dtstrf core_dtstrf_
    #define core_dgessm core_dgessm_
    #define core_dssssm core_dssssm_
#endif

#ifdef UPCASE
    #define dpotrf DPOTRF
    #define core_dgeqrt CORE_DGEQRT
    #define core_dtsqrt CORE_DTSQRT
    #define core_dormqr CORE_DORMQR
    #define core_dormlq CORE_DORMLQ
    #define core_dssrfb CORE_DSSRFB
    #define core_dssmqr CORE_DSSMQR
    #define core_dssmlq CORE_DSSMLQ
    #define core_dgelqt CORE_DGELQT
    #define core_dtslqt CORE_DTSLQT
    #define core_dgetrf CORE_DGETRF
    #define core_dtstrf CORE_DTSTRF
    #define core_dgessm CORE_DGESSM
    #define core_dssssm CORE_DSSSSM
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  FORTRAN prototypes
void dpotrf(char*, int*, double*, int*, int*);
void core_dgeqrt(int*, int*, int*, double*, int*, double*, int*, double*, double*, int*);
void core_dtsqrt(int*, int*, int*, double*, int*, double*, int*, double*, int*, double*, double*, int*);
void core_dormqr(char*, char*, int*, int*, int*, int*, double*, int*, double*, int*, double*, int*, double*, int*, int*);
void core_dormlq(char*, char*, int*, int*, int*, int*, double*, int*, double*, int*, double*, int*, double*, int*, int*);
void core_dssrfb(char*, char*, int*, int*, int*, int*, int*, double*, int*, double*, int*, double*, int*, double*, int*, double*, int*);
void core_dssmqr(char*, char*, int*, int*, int*, int*, int*, double*, int*, double*, int*, double*, int*, double*, int*, double*, int*, int*);
void core_dssmlq(char*, char*, int*, int*, int*, int*, int*, double*, int*, double*, int*, double*, int*, double*, int*, double*, int*, int*);
void core_dgelqt(int*, int*, int*, double*, int*, double*, int*, double*, double*, int*);
void core_dtslqt(int*, int*, int*, double*, int*, double*, int*, double*, int*, double*, double*, int*);
void core_dgetrf(int*, int*, int*, double*, int*, int*, int*);
void core_dtstrf(int*, int*, int*, int*, double*, int*, double*, int*, double*, int*, int *, double*, int*, int*);
void core_dgessm(int*, int*, int*, int*, int*, double*, int*, double*, int*, int*);
void core_dssssm(int*, int*, int*, int*, int*, double*, int*, double*, int*, double*, int*, double*, int*, int*, int*);

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  C prototypes
void CORE_dgelqt(int M, int N, int IB,
                 double *A, int LDA,
                 double *T, int LDT,
                 double *TAU, double *WORK);
void CORE_dgemm(int transA, int transB,
                int M, int N, int K,
                double alpha, double *A, int LDA,
                double *B, int LDB,
                double beta, double *C, int LDC);
void CORE_dgeqrt(int M, int N, int IB,
                 double *A, int LDA,
                 double *T, int LDT,
                 double *TAU, double *WORK);
void CORE_dgessm(int M, int N, int K, int IB,
                 int *IPIV,
                 double *L, int LDL,
                 double *A, int LDA);
void CORE_dgetrf(int M, int N, int IB,
                 double *A, int LDA,
                 int *IPIV, int *INFO);
void CORE_dpotrf(int uplo, int N, double *A, int LDA, int *INFO);
void CORE_dssmlq(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 double *A1, int LDA1,
                 double *A2, int LDA2,
                 double *V, int LDV,
                 double *T, int LDT,
                 double *WORK, int LDWORK);
void CORE_dssmqr(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 double *A1, int LDA1,
                 double *A2, int LDA2,
                 double *V, int LDV,
                 double *T, int LDT,
                 double *WORK, int LDWORK);
void CORE_dssssm(int M1, int M2, int NN, int IB, int K,
                 double *A1, int LDA1,
                 double *A2, int LDA2,
                 double *L1, int LDL1,
                 double *L2, int LDL2,
                 int *IPIV);
void CORE_dsyrk(int uplo, int trans,
                int N, int K,
                double alpha, double *A, int LDA,
                double beta, double *C, int LDC);
void CORE_dtrsm(int side, int uplo,
                int transA, int diag,
                int M, int N,
                double alpha, double *A, int LDA,
                double *B, int LDB);
void CORE_dtslqt(int M, int N, int IB,
                 double *A1, int LDA1,
                 double *A2, int LDA2,
                 double *T, int LDT,
                 double *TAU, double *WORK);
void CORE_dtsqrt(int M, int N, int IB,
                 double *A1, int LDA1,
                 double *A2, int LDA2,
                 double *T, int LDT,
                 double *TAU, double *WORK);
void CORE_dtstrf(int M, int N, int IB, int NB,
                 double *U, int LDU,
                 double *A, int LDA,
                 double *L, int LDL,
                 int *IPIV, double *WORK,
                 int LDWORK, int *INFO);
void CORE_dormlq(int side, int trans,
                 int M, int N, int IB, int K,
                 double *V, int LDV,
                 double *T, int LDT,
                 double *C, int LDC,
                 double *WORK, int LDWORK);
void CORE_dormqr(int side, int trans,
                 int M, int N, int IB, int K,
                 double *V, int LDV,
                 double *T, int LDT,
                 double *C, int LDC,
                 double *WORK, int LDWORK);

#ifdef __cplusplus
}
#endif

#endif
