/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak, Hatem Ltaief                                 ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"
#include "core_blas.h"
#include "lapack.h"

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_dgelqt(int M, int N, int IB,
                 double *A, int LDA,
                 double *T, int LDT,
                 double *TAU, double *WORK)
{
    int INFO;

    core_dgelqt(
        &M, &N, &IB,
        A, &LDA,
        T, &LDT,
        TAU, WORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_dgemm(int transA, int transB,
                int M, int N, int K,
                double alpha, double *A, int LDA,
                double *B, int LDB,
                double beta, double *C, int LDC)
{
    cblas_dgemm(
        CblasColMajor,
        (CBLAS_TRANSPOSE)transA, (CBLAS_TRANSPOSE)transB,
        M, N, K,
        (alpha), A, LDA,
        B, LDB,
        (beta), C, LDC);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_dgeqrt(int M, int N, int IB,
                 double *A, int LDA,
                 double *T, int LDT,
                 double *TAU, double *WORK)
{
    int INFO;

    core_dgeqrt(
        &M, &N, &IB,
        A, &LDA,
        T, &LDT,
        TAU, WORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_dgessm(int M, int N, int K, int IB,
                 int *IPIV,
                 double *L, int LDL,
                 double *A, int LDA)
{
    int INFO;

    core_dgessm(
        &M, &N, &K, &IB,
        IPIV,
        L, &LDL,
        A, &LDA,
        &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_dgetrf(int M, int N, int IB,
                 double *A, int LDA,
                 int *IPIV, int *INFO)
{
    core_dgetrf(
        &M, &N, &IB,
        A, &LDA,
        IPIV, INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_dpotrf(int uplo, int N, double *A, int LDA, int *INFO)
{
    dpotrf(lapack_const(uplo), &N, A, &LDA, INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_dssmlq(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 double *A1, int LDA1,
                 double *A2, int LDA2,
                 double *V, int LDV,
                 double *T, int LDT,
                 double *WORK, int LDWORK)
{
    int INFO;

    core_dssmlq(
        lapack_const(side), lapack_const(trans),
        &M1, &M2, &NN, &IB, &K,
        A1, &LDA1,
        A2, &LDA2,
        V, &LDV,
        T, &LDT,
        WORK, &LDWORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_dssmqr(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 double *A1, int LDA1,
                 double *A2, int LDA2,
                 double *V, int LDV,
                 double *T, int LDT,
                 double *WORK, int LDWORK)
{
    int INFO;

    core_dssmqr(
        lapack_const(side), lapack_const(trans),
        &M1, &M2, &NN, &IB, &K,
        A1, &LDA1,
        A2, &LDA2,
        V, &LDV,
        T, &LDT,
        WORK, &LDWORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_dssssm(int M1, int M2, int NN, int IB, int K,
                 double *A1, int LDA1,
                 double *A2, int LDA2,
                 double *L1, int LDL1,
                 double *L2, int LDL2,
                 int *IPIV)
{
    int INFO;

    core_dssssm(
        &M1, &M2, &NN, &IB, &K,
        A1, &LDA1,
        A2, &LDA2,
        L1, &LDL1,
        L2, &LDL2,
        IPIV,
        &INFO);
}
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_dsyrk(int uplo, int trans,
                int N, int K,
                double alpha, double *A, int LDA,
                double beta, double *C, int LDC)
{
    cblas_dsyrk(
        CblasColMajor,
        (CBLAS_UPLO)uplo, (CBLAS_TRANSPOSE)trans,
        N, K,
        (alpha), A, LDA,
        (beta), C, LDC);
}
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_dtrsm(int side, int uplo,
                int transA, int diag,
                int M, int N,
                double alpha, double *A, int LDA,
                double *B, int LDB)
{
    cblas_dtrsm(
        CblasColMajor,
        (CBLAS_SIDE)side, (CBLAS_UPLO)uplo,
        (CBLAS_TRANSPOSE)transA, (CBLAS_DIAG)diag,
        M, N,
        (alpha), A, LDA,
        B, LDB);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_dtslqt(int M, int N, int IB,
                 double *A1, int LDA1,
                 double *A2, int LDA2,
                 double *T, int LDT,
                 double *TAU, double *WORK)
{
    int INFO;

    core_dtslqt(
        &M, &N, &IB,
        A1, &LDA1,
        A2, &LDA2,
        T, &LDT,
        TAU, WORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_dtsqrt(int M, int N, int IB,
                 double *A1, int LDA1,
                 double *A2, int LDA2,
                 double *T, int LDT,
                 double *TAU, double *WORK)
{
    int INFO;

    core_dtsqrt(
        &M, &N, &IB,
        A1, &LDA1,
        A2, &LDA2,
        T, &LDT,
        TAU, WORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_dtstrf(int M, int N, int IB, int NB,
                 double *U, int LDU,
                 double *A, int LDA,
                 double *L, int LDL,
                 int *IPIV, double *WORK,
                 int LDWORK, int *INFO)
{
    core_dtstrf(
        &M, &N, &IB, &NB,
        U, &LDU,
        A, &LDA,
        L, &LDL,
        IPIV,
        WORK, &LDWORK, INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_dormlq(int side, int trans,
                 int M, int N, int IB, int K,
                 double *V, int LDV,
                 double *T, int LDT,
                 double *C, int LDC,
                 double *WORK, int LDWORK)
{
    int INFO;

    core_dormlq(
        lapack_const(side), lapack_const(trans),
        &M, &N, &IB, &K,
        V, &LDV,
        T, &LDT,
        C, &LDC,
        WORK, &LDWORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_dormqr(int side, int trans,
                 int M, int N, int IB, int K,
                 double *V, int LDV,
                 double *T, int LDT,
                 double *C, int LDC,
                 double *WORK, int LDWORK)
{
    int INFO;

    core_dormqr(
        lapack_const(side), lapack_const(trans),
        &M, &N, &IB, &K,
        V, &LDV,
        T, &LDT,
        C, &LDC,
        WORK, &LDWORK, &INFO);
}
