/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak, Hatem Ltaief                                 ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#ifndef _PLASMA_CORE_CBLAS_H_
#define _PLASMA_CORE_CBLAS_H_

#ifdef ADD_
    #define cpotrf cpotrf_
    #define core_cgeqrt core_cgeqrt_
    #define core_ctsqrt core_ctsqrt_
    #define core_cunmqr core_cunmqr_
    #define core_cunmlq core_cunmlq_
    #define core_cssrfb core_cssrfb_
    #define core_cssmqr core_cssmqr_
    #define core_cssmlq core_cssmlq_
    #define core_cgelqt core_cgelqt_
    #define core_ctslqt core_ctslqt_
    #define core_cgetrf core_cgetrf_
    #define core_ctstrf core_ctstrf_
    #define core_cgessm core_cgessm_
    #define core_cssssm core_cssssm_
#endif

#ifdef UPCASE
    #define cpotrf CPOTRF
    #define core_cgeqrt CORE_CGEQRT
    #define core_ctsqrt CORE_CTSQRT
    #define core_cunmqr CORE_CUNMQR
    #define core_cunmlq CORE_CUNMLQ
    #define core_cssrfb CORE_CSSRFB
    #define core_cssmqr CORE_CSSMQR
    #define core_cssmlq CORE_CSSMLQ
    #define core_cgelqt CORE_CGELQT
    #define core_ctslqt CORE_CTSLQT
    #define core_cgetrf CORE_CGETRF
    #define core_ctstrf CORE_CTSTRF
    #define core_cgessm CORE_CGESSM
    #define core_cssssm CORE_CSSSSM
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  FORTRAN prototypes
void cpotrf(char*, int*, PLASMA_Complex32_t*, int*, int*);
void core_cgeqrt(int*, int*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, PLASMA_Complex32_t*, int*);
void core_ctsqrt(int*, int*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, PLASMA_Complex32_t*, int*);
void core_cunmqr(char*, char*, int*, int*, int*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, int*);
void core_cunmlq(char*, char*, int*, int*, int*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, int*);
void core_cssrfb(char*, char*, int*, int*, int*, int*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*);
void core_cssmqr(char*, char*, int*, int*, int*, int*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, int*);
void core_cssmlq(char*, char*, int*, int*, int*, int*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, int*);
void core_cgelqt(int*, int*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, PLASMA_Complex32_t*, int*);
void core_ctslqt(int*, int*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, PLASMA_Complex32_t*, int*);
void core_cgetrf(int*, int*, int*, PLASMA_Complex32_t*, int*, int*, int*);
void core_ctstrf(int*, int*, int*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, int *, PLASMA_Complex32_t*, int*, int*);
void core_cgessm(int*, int*, int*, int*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, int*);
void core_cssssm(int*, int*, int*, int*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, PLASMA_Complex32_t*, int*, int*, int*);

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  C prototypes
void CORE_cgelqt(int M, int N, int IB,
                 PLASMA_Complex32_t *A, int LDA,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK);
void CORE_cgemm(int transA, int transB,
                int M, int N, int K,
                PLASMA_Complex32_t alpha, PLASMA_Complex32_t *A, int LDA,
                PLASMA_Complex32_t *B, int LDB,
                PLASMA_Complex32_t beta, PLASMA_Complex32_t *C, int LDC);
void CORE_cgeqrt(int M, int N, int IB,
                 PLASMA_Complex32_t *A, int LDA,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK);
void CORE_cgessm(int M, int N, int K, int IB,
                 int *IPIV,
                 PLASMA_Complex32_t *L, int LDL,
                 PLASMA_Complex32_t *A, int LDA);
void CORE_cgetrf(int M, int N, int IB,
                 PLASMA_Complex32_t *A, int LDA,
                 int *IPIV, int *INFO);
void CORE_cpotrf(int uplo, int N, PLASMA_Complex32_t *A, int LDA, int *INFO);
void CORE_cssmlq(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex32_t *A1, int LDA1,
                 PLASMA_Complex32_t *A2, int LDA2,
                 PLASMA_Complex32_t *V, int LDV,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *WORK, int LDWORK);
void CORE_cssmqr(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex32_t *A1, int LDA1,
                 PLASMA_Complex32_t *A2, int LDA2,
                 PLASMA_Complex32_t *V, int LDV,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *WORK, int LDWORK);
void CORE_cssssm(int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex32_t *A1, int LDA1,
                 PLASMA_Complex32_t *A2, int LDA2,
                 PLASMA_Complex32_t *L1, int LDL1,
                 PLASMA_Complex32_t *L2, int LDL2,
                 int *IPIV);
void CORE_cherk(int uplo, int trans,
                int N, int K,
                float alpha, PLASMA_Complex32_t *A, int LDA,
                float beta, PLASMA_Complex32_t *C, int LDC);
void CORE_csyrk(int uplo, int trans,
                int N, int K,
                PLASMA_Complex32_t alpha, PLASMA_Complex32_t *A, int LDA,
                PLASMA_Complex32_t beta, PLASMA_Complex32_t *C, int LDC);
void CORE_ctrsm(int side, int uplo,
                int transA, int diag,
                int M, int N,
                PLASMA_Complex32_t alpha, PLASMA_Complex32_t *A, int LDA,
                PLASMA_Complex32_t *B, int LDB);
void CORE_ctslqt(int M, int N, int IB,
                 PLASMA_Complex32_t *A1, int LDA1,
                 PLASMA_Complex32_t *A2, int LDA2,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK);
void CORE_ctsqrt(int M, int N, int IB,
                 PLASMA_Complex32_t *A1, int LDA1,
                 PLASMA_Complex32_t *A2, int LDA2,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK);
void CORE_ctstrf(int M, int N, int IB, int NB,
                 PLASMA_Complex32_t *U, int LDU,
                 PLASMA_Complex32_t *A, int LDA,
                 PLASMA_Complex32_t *L, int LDL,
                 int *IPIV, PLASMA_Complex32_t *WORK,
                 int LDWORK, int *INFO);
void CORE_cunmlq(int side, int trans,
                 int M, int N, int IB, int K,
                 PLASMA_Complex32_t *V, int LDV,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *C, int LDC,
                 PLASMA_Complex32_t *WORK, int LDWORK);
void CORE_cunmqr(int side, int trans,
                 int M, int N, int IB, int K,
                 PLASMA_Complex32_t *V, int LDV,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *C, int LDC,
                 PLASMA_Complex32_t *WORK, int LDWORK);

#ifdef __cplusplus
}
#endif

#endif
