/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak, Hatem Ltaief                                 ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"
#include "core_blas.h"
#include "lapack.h"

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_cgelqt(int M, int N, int IB,
                 PLASMA_Complex32_t *A, int LDA,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK)
{
    int INFO;

    core_cgelqt(
        &M, &N, &IB,
        A, &LDA,
        T, &LDT,
        TAU, WORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_cgemm(int transA, int transB,
                int M, int N, int K,
                PLASMA_Complex32_t alpha, PLASMA_Complex32_t *A, int LDA,
                PLASMA_Complex32_t *B, int LDB,
                PLASMA_Complex32_t beta, PLASMA_Complex32_t *C, int LDC)
{
    cblas_cgemm(
        CblasColMajor,
        (CBLAS_TRANSPOSE)transA, (CBLAS_TRANSPOSE)transB,
        M, N, K,
        CBLAS_SADDR(alpha), A, LDA,
        B, LDB,
        CBLAS_SADDR(beta), C, LDC);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_cgeqrt(int M, int N, int IB,
                 PLASMA_Complex32_t *A, int LDA,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK)
{
    int INFO;

    core_cgeqrt(
        &M, &N, &IB,
        A, &LDA,
        T, &LDT,
        TAU, WORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_cgessm(int M, int N, int K, int IB,
                 int *IPIV,
                 PLASMA_Complex32_t *L, int LDL,
                 PLASMA_Complex32_t *A, int LDA)
{
    int INFO;

    core_cgessm(
        &M, &N, &K, &IB,
        IPIV,
        L, &LDL,
        A, &LDA,
        &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_cgetrf(int M, int N, int IB,
                 PLASMA_Complex32_t *A, int LDA,
                 int *IPIV, int *INFO)
{
    core_cgetrf(
        &M, &N, &IB,
        A, &LDA,
        IPIV, INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_cpotrf(int uplo, int N, PLASMA_Complex32_t *A, int LDA, int *INFO)
{
    cpotrf(lapack_const(uplo), &N, A, &LDA, INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_cssmlq(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex32_t *A1, int LDA1,
                 PLASMA_Complex32_t *A2, int LDA2,
                 PLASMA_Complex32_t *V, int LDV,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *WORK, int LDWORK)
{
    int INFO;

    core_cssmlq(
        lapack_const(side), lapack_const(trans),
        &M1, &M2, &NN, &IB, &K,
        A1, &LDA1,
        A2, &LDA2,
        V, &LDV,
        T, &LDT,
        WORK, &LDWORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_cssmqr(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex32_t *A1, int LDA1,
                 PLASMA_Complex32_t *A2, int LDA2,
                 PLASMA_Complex32_t *V, int LDV,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *WORK, int LDWORK)
{
    int INFO;

    core_cssmqr(
        lapack_const(side), lapack_const(trans),
        &M1, &M2, &NN, &IB, &K,
        A1, &LDA1,
        A2, &LDA2,
        V, &LDV,
        T, &LDT,
        WORK, &LDWORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_cssssm(int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex32_t *A1, int LDA1,
                 PLASMA_Complex32_t *A2, int LDA2,
                 PLASMA_Complex32_t *L1, int LDL1,
                 PLASMA_Complex32_t *L2, int LDL2,
                 int *IPIV)
{
    int INFO;

    core_cssssm(
        &M1, &M2, &NN, &IB, &K,
        A1, &LDA1,
        A2, &LDA2,
        L1, &LDL1,
        L2, &LDL2,
        IPIV,
        &INFO);
}
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_cherk(int uplo, int trans,
                int N, int K,
                float alpha, PLASMA_Complex32_t *A, int LDA,
                float beta, PLASMA_Complex32_t *C, int LDC)
{
    cblas_cherk(
        CblasColMajor,
        (CBLAS_UPLO)uplo, (CBLAS_TRANSPOSE)trans,
        N, K,
        alpha, A, LDA,
        beta, C, LDC);
}
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_csyrk(int uplo, int trans,
                int N, int K,
                PLASMA_Complex32_t alpha, PLASMA_Complex32_t *A, int LDA,
                PLASMA_Complex32_t beta, PLASMA_Complex32_t *C, int LDC)
{
    cblas_csyrk(
        CblasColMajor,
        (CBLAS_UPLO)uplo, (CBLAS_TRANSPOSE)trans,
        N, K,
        CBLAS_SADDR(alpha), A, LDA,
        CBLAS_SADDR(beta), C, LDC);
}
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_ctrsm(int side, int uplo,
                int transA, int diag,
                int M, int N,
                PLASMA_Complex32_t alpha, PLASMA_Complex32_t *A, int LDA,
                PLASMA_Complex32_t *B, int LDB)
{
    cblas_ctrsm(
        CblasColMajor,
        (CBLAS_SIDE)side, (CBLAS_UPLO)uplo,
        (CBLAS_TRANSPOSE)transA, (CBLAS_DIAG)diag,
        M, N,
        CBLAS_SADDR(alpha), A, LDA,
        B, LDB);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_ctslqt(int M, int N, int IB,
                 PLASMA_Complex32_t *A1, int LDA1,
                 PLASMA_Complex32_t *A2, int LDA2,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK)
{
    int INFO;

    core_ctslqt(
        &M, &N, &IB,
        A1, &LDA1,
        A2, &LDA2,
        T, &LDT,
        TAU, WORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_ctsqrt(int M, int N, int IB,
                 PLASMA_Complex32_t *A1, int LDA1,
                 PLASMA_Complex32_t *A2, int LDA2,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *TAU, PLASMA_Complex32_t *WORK)
{
    int INFO;

    core_ctsqrt(
        &M, &N, &IB,
        A1, &LDA1,
        A2, &LDA2,
        T, &LDT,
        TAU, WORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_ctstrf(int M, int N, int IB, int NB,
                 PLASMA_Complex32_t *U, int LDU,
                 PLASMA_Complex32_t *A, int LDA,
                 PLASMA_Complex32_t *L, int LDL,
                 int *IPIV, PLASMA_Complex32_t *WORK,
                 int LDWORK, int *INFO)
{
    core_ctstrf(
        &M, &N, &IB, &NB,
        U, &LDU,
        A, &LDA,
        L, &LDL,
        IPIV,
        WORK, &LDWORK, INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_cunmlq(int side, int trans,
                 int M, int N, int IB, int K,
                 PLASMA_Complex32_t *V, int LDV,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *C, int LDC,
                 PLASMA_Complex32_t *WORK, int LDWORK)
{
    int INFO;

    core_cunmlq(
        lapack_const(side), lapack_const(trans),
        &M, &N, &IB, &K,
        V, &LDV,
        T, &LDT,
        C, &LDC,
        WORK, &LDWORK, &INFO);
}

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
void CORE_cunmqr(int side, int trans,
                 int M, int N, int IB, int K,
                 PLASMA_Complex32_t *V, int LDV,
                 PLASMA_Complex32_t *T, int LDT,
                 PLASMA_Complex32_t *C, int LDC,
                 PLASMA_Complex32_t *WORK, int LDWORK)
{
    int INFO;

    core_cunmqr(
        lapack_const(side), lapack_const(trans),
        &M, &N, &IB, &K,
        V, &LDV,
        T, &LDT,
        C, &LDC,
        WORK, &LDWORK, &INFO);
}
