/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak                                               ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#ifndef _PLASMA_CONTROL_H_
#define _PLASMA_CONTROL_H_

#ifndef __cplusplus
extern int pthread_getconcurrency(void);
extern int pthread_setconcurrency(int);
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Internal routines
void plasma_barrier_init(plasma_context_t *plasma);
void plasma_barrier(plasma_context_t *plasma);
void *plasma_parallel_section(void *plasma);

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  User routines
int PLASMA_Init(int cores);
int PLASMA_Finalize();

#ifdef __cplusplus
}
#endif

#endif
