/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.1.0)                          ///
 * ///                    Author: Jakub Kurzak                                               ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#ifndef _PLASMA_CONTEXT_H_
#define _PLASMA_CONTEXT_H_

struct plasma_context_struct;

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  PLASMA context
typedef struct plasma_context_struct {
    /* Initialization flag */
    PLASMA_bool initialized;

    /* Thread control */
    int world_size;
    int thread_rank[CONTEXT_THREADS_MAX];
    pthread_attr_t thread_attr;
    pthread_t thread_id[CONTEXT_THREADS_MAX];

    /* Master-worker communication */
    pthread_mutex_t action_mutex;
    pthread_cond_t action_condt;
    volatile PLASMA_enum action;
    void (*parallel_func_ptr)(struct plasma_context_struct *);
    unsigned char args_buff[ARGS_BUFF_SIZE];

    /* Boolean flags */
    PLASMA_bool errors_enabled;
    PLASMA_bool warnings_enabled;
    PLASMA_bool autotuning_enabled;

    /* Matrix tile attributes */
    int nb;
    int ib;
    int nbnbsize;   // tile size in elements (possibly padded)
    int ibnbsize;   // T or L tile size in elements (---''---)
    int info;

    /* Barrier implementation */
    volatile int barrier_in[CONTEXT_THREADS_MAX];
    volatile int barrier_out[CONTEXT_THREADS_MAX];

    /* Static scheduler implementation */
    int ss_ld;                  // static scheduler progress table leading dimension
    volatile int ss_abort;      // static scheduler abort flag
    volatile int *ss_progress;  // static scheduler progress table
} plasma_context_t;

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Threads contexts map
typedef struct plasma_context_map_struct {
    pthread_t thread_id;        // thread id
    plasma_context_t *context;  // pointer to associated context
} plasma_context_map_t;

#ifdef __cplusplus
extern "C" {
#endif

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Internal routines
plasma_context_t *plasma_context_create();
int plasma_context_insert(plasma_context_t *context, pthread_t thread_id);
int plasma_context_remove(plasma_context_t *context, pthread_t thread_id);
plasma_context_t *plasma_context_self();

#ifdef __cplusplus
}
#endif

#endif
