/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA header file (version 2.1.0)                                 ///
 * ///                    Release Date: November, 15th 2009                                  ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#ifndef _PLASMA_M_H_
#define _PLASMA_M_H_

#if defined(c_plusplus) || defined(__cplusplus)
extern "C" {
#endif

/* /////////////////////////// P /// U /// R /// P /// O /// S /// E /////////////////////////// */
// plasma_m.h - PLASMA header file for iterative refinement routines 

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Math function prototypes
int PLASMA_zcgesv(int N, int NRHS, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *B, int LDB, PLASMA_Complex64_t *X, int LDX, int *ITER);
int PLASMA_dsgesv(int N, int NRHS, double *A, int LDA, double *B, int LDB, double *X, int LDX, int *ITER);

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Math functions - native interface
int PLASMA_zcgesv_Tile(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, PLASMA_desc *X, int *ITER);
int PLASMA_dsgesv_Tile(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, PLASMA_desc *X, int *ITER);

#if defined(c_plusplus) || defined(__cplusplus)
}
#endif

#endif
