      SUBROUTINE CORE_ZSSMLQ( SIDE, TRANS, M1, M2, NN, IB, K, A1, LDA1,
     $                       A2, LDA2, V, LDV, T, LDT, WORK, LDWORK,
     $                       INFO )

*********************************************************************
*     PLASMA core_blas routine (version 2.1.0)                      *
*     Author: Hatem Ltaief                                          *
*     Release Date: November, 15th 2009                             *
*     PLASMA is a software package provided by Univ. of Tennessee,  *
*     Univ. of California Berkeley and Univ. of Colorado Denver.    *
*********************************************************************
*
*     .. Scalar Arguments ..
      CHARACTER          SIDE, TRANS
      INTEGER            M1, M2, NN, K, IB, LDA1, LDA2, LDV, LDT
      INTEGER            LDWORK, INFO
*     ..
*     .. Array Arguments ..
      COMPLEX*16            A1( LDA1, * ), A2( LDA2, * )
      COMPLEX*16            V( LDV, * ), T( LDT, * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  CORE_ZSSMLQ overwrites the general complex NN-by-M1 tile A1 and
*  NN-by-M2 tile A2 with
*
*                      SIDE = 'L'        SIDE = 'R'
*  TRANS = 'N':         Q * | A1 |       | A1 | * Q
*                           | A2 |       | A2 |
*
*  TRANS = 'C':      Q**H * | A1 |       | A1 | * Q**H
*                           | A2 |       | A2 |
*
*  where Q is a complex unitary matrix defined as the product of k
*  elementary reflectors
*
*        Q = H(k)' . . . H(2)' H(1)'
*
*  as returned by CORE_ZTSLQT.
*
*  Only 2 scenarios are supported:
*  LEFT and ConjTranspose
*  RIGHT and NoTranspose
*
*  Arguments
*  =========
*
*  SIDE    (input) CHARACTER*1
*          = 'L': apply Q or Q**H from the Left;
*          = 'R': apply Q or Q**H from the Right.
*
*  TRANS   (input) CHARACTER*1
*          = 'N':  No transpose, apply Q;
*          = 'C':  ConjTranspose, apply Q**H.
*
*  M1      (input) INTEGER
*          The number of columns of the tile A1. M1 >= 0.
*
*  M2      (input) INTEGER
*          The number of columns of the tile A2. M2 >= 0.
*
*  NN      (input) INTEGER
*          The number of rows of the tiles A1 and A2. NN >= 0.
*
*  IB      (input) INTEGER
*          The inner-blocking size.  IB >= 0.
*
*  K       (input) INTEGER
*          The number of elementary reflectors whose product defines
*          the matrix Q.
*
*  A1      (input/output) COMPLEX*16 array, dimension (LDA1,NN)
*          On entry, the NN-by-M1 tile A1.
*          On exit, A1 is overwritten by the application of Q.
*
*  LDA1    (input) INTEGER
*          The leading dimension of the array A1. LDA1 >= max(1,NN).
*
*  A2      (input/output) COMPLEX*16 array, dimension (LDA2,NN)
*          On entry, the NN-by-M2 tile A2.
*          On exit, A2 is overwritten by the application of Q.
*
*  LDA2    (input) INTEGER
*          The leading dimension of the tile A2. LDA2 >= max(1,NN).
*
*  V       (input) COMPLEX*16 array, dimension (LDA,K)
*          The i-th row must contain the vector which defines the
*          elementary reflector H(i), for i = 1,2,...,k, as returned by
*          CORE_ZTSLQT in the first k rows of its array argument V.
*
*  LDV     (input) INTEGER
*          The leading dimension of the array V. LDV >= max(1,K).
*
*  T       (output) COMPLEX*16 array, dimension (LDT,NN)
*          The IB-by-NN triangular factor T of the block reflector.
*          T is upper triangular by block (economic storage);
*          The rest of the array is not referenced.
*
*  LDT     (input) INTEGER
*          The leading dimension of the array T. LDT >= IB.
*
*  WORK    (workspace/output) COMPLEX*16 array, dimension (MAX(1,LWORK))
*
*  LWORK   (input) INTEGER
*          The dimension of the array WORK.
*
*  INFO    (output) INTEGER
*          = 0:  successful exit
*          < 0:  if INFO = -i, the i-th argument had an illegal value
*
*  =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            LEFT, NOTRAN
      CHARACTER          TRANST
      INTEGER            I, I1, I2, I3, KB, IC, IINFO, JC,
     $                   MI, NI, NQ
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. External Subroutines ..
      EXTERNAL           ZLARFB, XERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN
*     ..
*     .. Executable Statements ..
*
*     Test the input arguments
*
      INFO = 0
      LEFT = LSAME( SIDE, 'L' )
      NOTRAN = LSAME( TRANS, 'N' )
*
*     Quick return if possible
*
      IF( M1.EQ.0 .OR. M2.EQ.0 .OR. NN.EQ.0 .OR. K.EQ.0 ) THEN
         RETURN
      END IF
*
*     NQ is the order of Q
*
      IF( LEFT ) THEN
         NQ = NN
      ELSE
         NQ = M1
      END IF
      IF( .NOT.LEFT .AND. .NOT.LSAME( SIDE, 'R' ) ) THEN
         INFO = -1
      ELSE IF( .NOT.NOTRAN .AND. .NOT.LSAME( TRANS, 'C' ) ) THEN
         INFO = -2
      ELSE IF( M1.LT.0 ) THEN
         INFO = -3
      ELSE IF( M2.LT.0 ) THEN
         INFO = -4
      ELSE IF( NN.LT.0 ) THEN
         INFO = -5
      ELSE IF( IB.LT.0 ) THEN
         INFO = -6
*      ELSE IF( K.LT.0 .OR. K.GT.NQ ) THEN
*         INFO = -7
*      ELSE IF( LDA1.LT.MAX( 1, K ) ) THEN
*         INFO = -9
      END IF
*
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( 'CORE_ZSSMLQ', -INFO )
         RETURN
      END IF

*

      IF( ( LEFT .AND. NOTRAN ) .OR.
     $   ( .NOT.LEFT .AND. .NOT.NOTRAN ) ) THEN
         I1 = 1
         I2 = K
         I3 = IB
      ELSE
         I1 = ( ( K-1 ) / IB )*IB + 1
         I2 = 1
         I3 = -IB
      END IF
*
      IF( LEFT ) THEN
         NI = NN
         JC = 1
      ELSE
         MI = M2
         IC = 1
      END IF
*
      IF( NOTRAN ) THEN
         TRANST = 'C'
      ELSE
         TRANST = 'N'
      END IF
*
      DO 10 I = I1, I2, I3
         KB = MIN( IB, K-I+1 )
*
         IF( LEFT ) THEN
*
*           H or H' is applied to C(i:m,1:n)
*
            MI = NN - I + 1
            IC = I
         ELSE
*
*           H or H' is applied to C(1:m,i:n)
*
            NI = M1 - I + 1
            JC = I
         END IF
*
*        Apply H or H'
*
         CALL CORE_ZSSRFB( SIDE, TRANST, 'Forward', 'Rowwise',
     $                    M1, M2, NN, KB, A1( IC, JC ), LDA1,
     $                    A2( 1, 1 ), LDA2,
     $                    V( I, 1 ), LDV, T( 1, I ), LDT,
     $                    WORK, LDWORK, INFO )
   10 CONTINUE
      RETURN
*
*     End of CORE_ZSSMLQ
*
      END
