      SUBROUTINE CORE_DSSSSM( M1, M2, NN, IB, K, A0, LDA0, A1, LDA1,
     $                       L0, LDL0, L1, LDL1, IPIV, INFO )

*********************************************************************
*     PLASMA core_blas routine (version 2.1.0)                      *
*     Author: Hatem Ltaief                                          *
*     Release Date: November, 15th 2009                             *
*     PLASMA is a software package provided by Univ. of Tennessee,  *
*     Univ. of California Berkeley and Univ. of Colorado Denver.    *
*********************************************************************
*
*     .. Scalar Arguments ..
      INTEGER            M1, M2, IB, NN, K
      INTEGER            LDL0, LDL1, LDA0, LDA1, INFO
*     ..
*     .. Array Arguments ..
      DOUBLE PRECISION            A0( LDA0, * ), A1( LDA1, * )
      DOUBLE PRECISION            L0( LDL0, * ), L1( LDL1, * )
      INTEGER            IPIV( * )
*     ..
*
*  Purpose
*  =======
*
*  CORE_DSSSSM applies the factor L computed by CORE_DTSTRF to a
*  real matrix formed by coupling an M1-by-NN tile A0 on top
*  of a real M2-by-NN tile A1.
*
*  Arguments
*  =========
*
*
*  M1      (input) INTEGER
*          The number of rows of the tile A0. M1 >= 0.
*
*  M2      (input) INTEGER
*          The number of rows of the tile A1. M2 >= 0.
*
*  NN      (input) INTEGER
*          The number of columns of the tiles A0 and A1. NN >= 0.
*
*  IB      (input) INTEGER
*          The inner-blocking size.  IB >= 0.
*
*  K       (input) INTEGER
*
*
*  A0      (input/output) DOUBLE PRECISION array, dimension (LDA0,M1)
*          On entry, the M1-by-NN tile A0.
*          On exit, A0 is overwritten by the application of L.
*
*  LDA0    (input) INTEGER
*          The leading dimension of the tile A0. LDA0 >= max(1,M1).
*
*  A1      (input/output) DOUBLE PRECISION array, dimension (LDA1,M2)
*          On entry, the M2-by-NN tile A1.
*          On exit, A1 is overwritten by the application of L.
*
*  LDA1    (input) INTEGER
*          The leading dimension of the tile A1. LDA1 >= max(1,M2).
*
*  L0      (input) DOUBLE PRECISION array, dimension (LDL0,K)
*          The NB-by-NB lower triangular tile as returned by CORE_DTSTRF.
*
*  LDL0    (input) INTEGER
*          The leading dimension of the array L0. LDL0 >= max(1,K).
*
*  L1      (input) DOUBLE PRECISION array, dimension (LDL1,NB)
*          The NB-by-NB tile as returned by CORE_DTSTRF.
*
*  LDL1    (input) INTEGER
*          The leading dimension of the array L1.  LDL1 >= max(1,NB).
*
*  IPIV    (input) INTEGER array, dimension (min(M,N))
*          as returned by CORE_DTSTRF.
*
*  INFO    (output) INTEGER
*          = 0: successful exit
*          < 0: if INFO = -k, the k-th argument had an illegal value
*
*  =====================================================================
*     ..
*     .. Internal variables ..
      INTEGER            II, I, IP, IM, SB
*     .. Parameters ..
      DOUBLE PRECISION            DONE, MDONE
      PARAMETER          ( DONE = 1.0D+0 )
      PARAMETER          ( MDONE = -1.0D+0 )
*     ..
*     Test the input parameters.
      INFO = 0
      IF( M1.LT.0 ) THEN
         INFO = -1
      ELSE IF( M2.LT.0 ) THEN
         INFO = -2
      ELSE IF( NN.LT.0 ) THEN
         INFO = -3
      ELSE IF( IB.LT.0 ) THEN
         INFO = -4
      ELSE IF( K.LT.0 ) THEN
         INFO = -5
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( 'CORE_DSSSSM', -INFO )
         RETURN
      END IF
*
*     Quick return if possible.
*
      IF( M1.EQ.0 .OR. M2.EQ.0 .OR. NN.EQ.0 .OR. IB.EQ.0  .OR. K.EQ.0 )
     $   RETURN
*
      IP = 1
*
      DO 10 II = 1, K, IB
         SB = MIN( K-II+1, IB )
         DO 20 I = 1, IB
*
            IM = IPIV( IP )
            IF( IM.NE.II+I-1 ) THEN
               IM = IM - M1
               CALL DSWAP( NN, A0( II+I-1, 1 ), LDA0,
     $                    A1( IM, 1 ), LDA1 )
            END IF
            IP = IP+1
*
 20      CONTINUE
         CALL DTRSM( 'Left', 'Lower', 'Notranspose', 'Unit',
     $              SB, NN, DONE,
     $              L0( 1, II ), LDL0,
     $              A0( II, 1 ), LDA0 )
*
         CALL DGEMM( 'Notranspose', 'Notranspose',
     $              M2, NN, SB, MDONE,
     $              L1( 1, II ), LDL1,
     $              A0( II, 1 ), LDA0,
     $              DONE, A1, LDA1 )
     $
 10   CONTINUE
*
      RETURN
*
*     End of CORE_DSSSSM.
*
      END
