#! /usr/bin/env python


###############################################################################
# plasma_testing.py  [nbcores] 
#  nbcores is a optional argument to give the number of cores to run the testing
# Example:
#     ./plasma_testing.py 
#                 No argument, so will run on half of the core if the machine has more than 2 cores
#     ./plama_testing.py nbcores
#                 Will run on nbcores 
###############################################################################

import os, sys, math

# Linux Unix and MacOS: 
if hasattr(os, "sysconf"):
   if os.sysconf_names.has_key("SC_NPROCESSORS_ONLN"):
	   ncpus_av = os.sysconf("SC_NPROCESSORS_ONLN")
# Windows:
if os.environ.has_key("NUMBER_OF_PROCESSORS"):
   ncpus_av = int(os.environ["NUMBER_OF_PROCESSORS"]);

# If the user is proving us the number of core and this number is less than total core of the machine
if ((len(sys.argv)>1) and (int(sys.argv[1])<=ncpus_av)):
	ncpus=sys.argv[1]
else:
   # we are going to run on half of the cores by default if we have more than 2 cores
   if (ncpus_av > 2):
      ncpus=int(math.floor(ncpus_av/2))
   else:
      ncpus=ncpus_av


filename = "testing_results.txt"
print ' '
print '---------------- Testing PLASMA Routines ----------------'
print ' '
print '-- Number of cores available =', ncpus_av
print '-- Number of cores used for testing =', ncpus
print '-- Detailed results are stored in', filename

print ' '
print '------------------------- Single ------------------------'
print ' '
file = open(filename, 'w')
test1=os.popen("./testing_sposv " +str(ncpus)+ " 500 600 25 700")
for line in test1.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,

file.close()

file = open(filename, 'a')
test2=os.popen("./testing_sgels " +str(ncpus)+ " 800 400 825 25 810")
for line in test2.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,

file.close()

file = open(filename, 'a')
test3=os.popen("./testing_sgels " +str(ncpus)+ " 400 800 825 25 810")
for line in test3.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,

file.close()

file = open(filename, 'a')
test4=os.popen("./testing_sgesv " +str(ncpus)+ " 800 825 25 810")
for line in test4.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,


print ' '
print '------------------------- Double ------------------------'
print ' '
file = open(filename, 'a')
test5=os.popen("./testing_dposv " +str(ncpus)+ " 500 600 25 700")
for line in test5.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,

file.close()

file = open(filename, 'a')
test6=os.popen("./testing_dgels " +str(ncpus)+ " 800 400 825 25 810")
for line in test6.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,

file.close()

file = open(filename, 'a')
test7=os.popen("./testing_dgels " +str(ncpus)+ " 400 800 825 25 810")
for line in test7.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,

file.close()

file = open(filename, 'a')
test8=os.popen("./testing_dgesv " +str(ncpus)+ " 800 825 25 810")
for line in test8.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,


print ' '
print '--------------------- Single Complex  -------------------'
print ' '
file = open(filename, 'a')
test9=os.popen("./testing_cposv " +str(ncpus)+ " 500 600 25 700")
for line in test9.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,

file.close()

file = open(filename, 'a')
test10=os.popen("./testing_cgels " +str(ncpus)+ " 800 400 825 25 810")
for line in test10.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,

file.close()

file = open(filename, 'a')
test11=os.popen("./testing_cgels " +str(ncpus)+ " 400 800 825 25 810")
for line in test11.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,

file.close()

file = open(filename, 'a')
test12=os.popen("./testing_cgesv " +str(ncpus)+ " 800 825 25 810")
for line in test12.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,


print ' '
print '--------------------- Double Complex  -------------------'
print ' '
file = open(filename, 'a')
test13=os.popen("./testing_zposv " +str(ncpus)+ " 500 600 25 700")
for line in test13.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,

file.close()

file = open(filename, 'a')
test14=os.popen("./testing_zgels " +str(ncpus)+ " 800 400 825 25 810")
for line in test14.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,

file.close()

file = open(filename, 'a')
test15=os.popen("./testing_zgels " +str(ncpus)+ " 400 800 825 25 810")
for line in test15.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,

file.close()

file = open(filename, 'a')
test16=os.popen("./testing_zgesv " +str(ncpus)+ " 800 825 25 810")
for line in test16.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,

file.close()

print ' '
print '--------------------- Mixed Precision -------------------'
print ' '
file = open(filename, 'a')
test17=os.popen("./testing_zcgesv " +str(ncpus)+ " 800 825 25 810")
for line in test17.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,

file.close()

file = open(filename, 'a')
test18=os.popen("./testing_dsgesv " +str(ncpus)+ " 800 825 25 810")
for line in test18.readlines():
     file.write(str(line))
     if 'TESTING' in line : print line,

print ' '
file.close()
