/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.0.0)                          ///
 * ///                    Release Date: July, 4th 2009                                       ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#ifndef _PLASMA_WORKSPACE_H_
#define _PLASMA_WORKSPACE_H_

#ifdef __cplusplus
extern "C" {
#endif

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Internal routines
int plasma_alloc_ibnb(int M, int N, int operation, int type, void **memptr);
int plasma_alloc_ipiv(int M, int N, int operation, void **memptr);

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  User routines
int PLASMA_Dealloc_Handle(void **handle);

int PLASMA_Alloc_Workspace_zgels(int M, int N, PLASMA_Complex64_t **T);
int PLASMA_Alloc_Workspace_zgeqrf(int M, int N, PLASMA_Complex64_t **T);
int PLASMA_Alloc_Workspace_zgelqf(int M, int N, PLASMA_Complex64_t **T);
int PLASMA_Alloc_Workspace_zgesv(int N, PLASMA_Complex64_t **L, int **IPIV);
int PLASMA_Alloc_Workspace_zgetrf(int M, int N, PLASMA_Complex64_t **L, int **IPIV);

int PLASMA_Alloc_Workspace_dgels(int M, int N, double **T);
int PLASMA_Alloc_Workspace_dgeqrf(int M, int N, double **T);
int PLASMA_Alloc_Workspace_dgelqf(int M, int N, double **T);
int PLASMA_Alloc_Workspace_dgesv(int N, double **L, int **IPIV);
int PLASMA_Alloc_Workspace_dgetrf(int M, int N, double **L, int **IPIV);

int PLASMA_Alloc_Workspace_cgels(int M, int N, PLASMA_Complex32_t **T);
int PLASMA_Alloc_Workspace_cgeqrf(int M, int N, PLASMA_Complex32_t **T);
int PLASMA_Alloc_Workspace_cgelqf(int M, int N, PLASMA_Complex32_t **T);
int PLASMA_Alloc_Workspace_cgesv(int N, PLASMA_Complex32_t **L, int **IPIV);
int PLASMA_Alloc_Workspace_cgetrf(int M, int N, PLASMA_Complex32_t **L, int **IPIV);

int PLASMA_Alloc_Workspace_sgels(int M, int N, float **T);
int PLASMA_Alloc_Workspace_sgeqrf(int M, int N, float **T);
int PLASMA_Alloc_Workspace_sgelqf(int M, int N, float **T);
int PLASMA_Alloc_Workspace_sgesv(int N, float **L, int **IPIV);
int PLASMA_Alloc_Workspace_sgetrf(int M, int N, float **L, int **IPIV);

#ifdef __cplusplus
}
#endif

#endif
