/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.0.0)                          ///
 * ///                    Release Date: July, 4th 2009                                       ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#ifndef _PLASMA_TILE_H_
#define _PLASMA_TILE_H_

#ifdef __cplusplus
extern "C" {
#endif

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Internal routines
void plasma_tile_to_lapack(plasma_context_t *plasma);
void plasma_lapack_to_tile(plasma_context_t *plasma);
void plasma_tile_zero(plasma_context_t *plasma);

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  User routines
int PLASMA_Lapack_to_Tile(void *Af77, int LDA, PLASMA_desc *A);
int PLASMA_Tile_to_Lapack(PLASMA_desc *A, void *Af77, int LDA);

#ifdef __cplusplus
}
#endif

#endif
