/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.0.0)                          ///
 * ///                    Release Date: July, 4th 2009                                       ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Parallel construction of Q using tile V (application to identity)
#define A(m,n) &((PLASMA_Complex64_t*)A.mat)[A.bsiz*(m)+A.bsiz*A.lmt*(n)]
#define Q(m,n) &((PLASMA_Complex64_t*)Q.mat)[Q.bsiz*(m)+Q.bsiz*Q.lmt*(n)]
#define T(m,n) &((PLASMA_Complex64_t*)T.mat)[T.bsiz*(m)+T.bsiz*T.lmt*(n)]
void plasma_pzungqr(plasma_context_t *plasma)
{
    PLASMA_desc A;
    PLASMA_desc Q;
    PLASMA_desc T;

    int k, m, n;
    PLASMA_Complex64_t *work;

    // Currently sequential
    if (PLASMA_RANK > 0) return;

    plasma_unpack_args_3(A, Q, T);
    work = (PLASMA_Complex64_t *)plasma_private_alloc(plasma, T.mb*T.nb, T.dtyp);


    for (k = A.nt - 1; k >= 0; k--) {
        for (m = Q.mt - 1; m > k; m--) {
            for (n = 0; n < Q.nt; n++) {
                CORE_zssmqr(
                    PlasmaLeft, PlasmaNoTrans,
                    A.nb,
                    m == Q.mt-1 ? Q.m-m*Q.nb : Q.nb,
                    n == Q.nt-1 ? Q.n-n*Q.nb : Q.nb,
                    T.mb,
                    k == A.nt-1 ? A.n-k*A.nb : A.nb,
                    Q(k, n), Q.nb,
                    Q(m, n), Q.nb,
                    A(m, k), Q.nb,
                    T(m, k), T.mb,
                    work, T.mb);
            }
        }
        for (n = 0; n < Q.nt; n++) {
            CORE_zunmqr(
                PlasmaLeft, PlasmaNoTrans,
                k == A.mt-1 ? A.m-k*A.nb : A.nb,
                n == Q.nt-1 ? Q.n-n*Q.nb : Q.nb,
                T.mb,
                k == A.nt-1 ? min(A.m-k*A.nb, A.n-k*A.nb) : A.nb,
                A(k, k), A.nb,
                T(k, k), T.mb,
                Q(k, n), Q.nb,
                work, A.nb);
        }
    }
    plasma_private_free(plasma, work);
}
