/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.0.0)                          ///
 * ///                    Release Date: July, 4th 2009                                       ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#include "common.h"

#ifdef ADD_
    #define PLASMA_ZGELQF       plasma_zgelqf_
    #define PLASMA_ZGELQS       plasma_zgelqs_
    #define PLASMA_ZGELS        plasma_zgels_
    #define PLASMA_ZGEQRF       plasma_zgeqrf_
    #define PLASMA_ZGEQRS       plasma_zgeqrs_
    #define PLASMA_ZGESV        plasma_zgesv_
    #define PLASMA_ZGETRF       plasma_zgetrf_
    #define PLASMA_ZGETRS       plasma_zgetrs_
    #define PLASMA_ZPOSV        plasma_zposv_
    #define PLASMA_ZPOTRF       plasma_zpotrf_
    #define PLASMA_ZPOTRS       plasma_zpotrs_
    #define PLASMA_ZTRSM        plasma_ztrsm_
    #define PLASMA_ZTRSMPL      plasma_ztrsmpl_
    #define PLASMA_ZUNGLQ       plasma_zunglq_
    #define PLASMA_ZUNGQR       plasma_zungqr_
    #define PLASMA_ZUNMLQ       plasma_zunmlq_
    #define PLASMA_ZUNMQR       plasma_zunmqr_

    #define PLASMA_ZGELQF_TILE      plasma_zgelqf_tile_
    #define PLASMA_ZGELQS_TILE      plasma_zgelqs_tile_
    #define PLASMA_ZGELS_TILE       plasma_zgels_tile_
    #define PLASMA_ZGEQRF_TILE      plasma_zgeqrf_tile_
    #define PLASMA_ZGEQRS_TILE      plasma_zgeqrs_tile_
    #define PLASMA_ZGESV_TILE       plasma_zgesv_tile_
    #define PLASMA_ZGETRF_TILE      plasma_zgetrf_tile_
    #define PLASMA_ZGETRS_TILE      plasma_zgetrs_tile_
    #define PLASMA_ZPOSV_TILE       plasma_zposv_tile_
    #define PLASMA_ZPOTRF_TILE      plasma_zpotrf_tile_
    #define PLASMA_ZPOTRS_TILE      plasma_zpotrs_tile_
    #define PLASMA_ZTRSM_TILE       plasma_ztrsm_tile_
    #define PLASMA_ZTRSMPL_TILE     plasma_ztrsmpl_tile_
    #define PLASMA_ZUNGLQ_TILE      plasma_zunglq_tile_
    #define PLASMA_ZUNGQR_TILE      plasma_zungqr_tile_
    #define PLASMA_ZUNMLQ_TILE      plasma_zunmlq_tile_
    #define PLASMA_ZUNMQR_TILE      plasma_zunmqr_tile_

    #define PLASMA_ALLOC_WORKSPACE_ZGELQF       plasma_alloc_workspace_zgelqf_
    #define PLASMA_ALLOC_WORKSPACE_ZGELS        plasma_alloc_workspace_zgels_
    #define PLASMA_ALLOC_WORKSPACE_ZGEQRF       plasma_alloc_workspace_zgeqrf_
    #define PLASMA_ALLOC_WORKSPACE_ZGESV        plasma_alloc_workspace_zgesv_
    #define PLASMA_ALLOC_WORKSPACE_ZGETRF       plasma_alloc_workspace_zgetrf_
    #define PLASMA_ALLOC_WORKSPACE_ZGELQF       plasma_alloc_workspace_zgelqf_
#elif defined (NOCHANGE)
    #define PLASMA_ZGELQF       plasma_zgelqf
    #define PLASMA_ZGELQS       plasma_zgelqs
    #define PLASMA_ZGELS        plasma_zgels
    #define PLASMA_ZGEQRF       plasma_zgeqrf
    #define PLASMA_ZGEQRS       plasma_zgeqrs
    #define PLASMA_ZGESV        plasma_zgesv
    #define PLASMA_ZGETRF       plasma_zgetrf
    #define PLASMA_ZGETRS       plasma_zgetrs
    #define PLASMA_ZPOSV        plasma_zposv
    #define PLASMA_ZPOTRF       plasma_zpotrf
    #define PLASMA_ZPOTRS       plasma_zpotrs
    #define PLASMA_ZTRSM        plasma_ztrsm
    #define PLASMA_ZTRSMPL      plasma_ztrsmpl
    #define PLASMA_ZUNGLQ       plasma_zunglq
    #define PLASMA_ZUNGQR       plasma_zungqr
    #define PLASMA_ZUNMLQ       plasma_zunmlq
    #define PLASMA_ZUNMQR       plasma_zunmqr

    #define PLASMA_ZGELQF_TILE      plasma_zgelqf_tile
    #define PLASMA_ZGELQS_TILE      plasma_zgelqs_tile
    #define PLASMA_ZGELS_TILE       plasma_zgels_tile
    #define PLASMA_ZGEQRF_TILE      plasma_zgeqrf_tile
    #define PLASMA_ZGEQRS_TILE      plasma_zgeqrs_tile
    #define PLASMA_ZGESV_TILE       plasma_zgesv_tile
    #define PLASMA_ZGETRF_TILE      plasma_zgetrf_tile
    #define PLASMA_ZGETRS_TILE      plasma_zgetrs_tile
    #define PLASMA_ZPOSV_TILE       plasma_zposv_tile
    #define PLASMA_ZPOTRF_TILE      plasma_zpotrf_tile
    #define PLASMA_ZPOTRS_TILE      plasma_zpotrs_tile
    #define PLASMA_ZTRSM_TILE       plasma_ztrsm_tile
    #define PLASMA_ZTRSMPL_TILE     plasma_ztrsmpl_tile
    #define PLASMA_ZUNGLQ_TILE      plasma_zunglq_tile
    #define PLASMA_ZUNGQR_TILE      plasma_zungqr_tile
    #define PLASMA_ZUNMLQ_TILE      plasma_zunmlq_tile
    #define PLASMA_ZUNMQR_TILE      plasma_zunmqr_tile

    #define PLASMA_ALLOC_WORKSPACE_ZGELQF       plasma_alloc_workspace_zgelqf
    #define PLASMA_ALLOC_WORKSPACE_ZGELS        plasma_alloc_workspace_zgels
    #define PLASMA_ALLOC_WORKSPACE_ZGEQRF       plasma_alloc_workspace_zgeqrf
    #define PLASMA_ALLOC_WORKSPACE_ZGESV        plasma_alloc_workspace_zgesv
    #define PLASMA_ALLOC_WORKSPACE_ZGETRF       plasma_alloc_workspace_zgetrf
    #define PLASMA_ALLOC_WORKSPACE_ZGELQF       plasma_alloc_workspace_zgelqf
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  FORTRAN API - math functions
void PLASMA_ZGELQF(int *M, int *N, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t **T, int *INFO)
{   *INFO = PLASMA_zgelqf(*M, *N, A, *LDA, *T); }

void PLASMA_ZGELQS(int *M, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t **T, PLASMA_Complex64_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_zgelqs(*M, *N, *NRHS, A, *LDA, *T, B, *LDB); }

void PLASMA_ZGELS(PLASMA_enum *trans, int *M, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t **T, PLASMA_Complex64_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_zgels(*trans, *M, *N, *NRHS, A, *LDA, *T, B, *LDB); }

void PLASMA_ZGEQRF(int *M, int *N, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t **T, int *INFO)
{   *INFO = PLASMA_zgeqrf(*M, *N, A, *LDA, *T); }

void PLASMA_ZGEQRS(int *M, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t **T, PLASMA_Complex64_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_zgeqrs(*M, *N, *NRHS, A, *LDA, *T, B, *LDB); }

void PLASMA_ZGESV(int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t **LH, int **IPIVH, PLASMA_Complex64_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_zgesv(*N, *NRHS, A, *LDA, *LH, *IPIVH, B, *LDB); }

void PLASMA_ZGETRF(int *M, int *N, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t **LH, int **IPIVH, int *INFO)
{   *INFO = PLASMA_zgetrf(*M, *N, A, *LDA, *LH, *IPIVH); }

void PLASMA_ZGETRS(PLASMA_enum *uplo, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t **LH, int **IPIVH, PLASMA_Complex64_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_zgetrs(*uplo, *N, *NRHS, A, *LDA, *LH, *IPIVH, B, *LDB); }

void PLASMA_ZPOSV(PLASMA_enum *uplo, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_zposv(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_ZPOTRF(PLASMA_enum *uplo, int *N, PLASMA_Complex64_t *A, int *LDA, int *INFO)
{   *INFO = PLASMA_zpotrf(*uplo, *N, A, *LDA); }

void PLASMA_ZPOTRS(PLASMA_enum *uplo, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int* LDB, int * INFO)
{   *INFO = PLASMA_zpotrs(*uplo, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_ZTRSM(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_ztrsm(*side, *uplo, *transA, *diag, *N, *NRHS, A, *LDA, B, *LDB); }

void PLASMA_ZTRSMPL(int *N, int *NRHS, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t **LH, int **IPIVH, PLASMA_Complex64_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_ztrsmpl(*N, *NRHS, A, *LDA, *LH, *IPIVH, B, *LDB); }

void PLASMA_ZUNGLQ(int *M, int *N, int *K, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t **T, PLASMA_Complex64_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_zunglq(*M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_ZUNGQR(int *M, int *N, int *K, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t **T, PLASMA_Complex64_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_zungqr(*M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_ZUNMLQ(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t **T, PLASMA_Complex64_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_zunmlq(*side, *trans, *M, *N, *K, A, *LDA, *T, B, *LDB); }

void PLASMA_ZUNMQR(PLASMA_enum *side, PLASMA_enum *trans, int *M, int *N, int *K, PLASMA_Complex64_t *A, int *LDA, PLASMA_Complex64_t **T, PLASMA_Complex64_t *B, int *LDB, int *INFO)
{   *INFO = PLASMA_zunmqr(*side, *trans, *M, *N, *K, A, *LDA, *T, B, *LDB); }

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Math functions - native interface
void PLASMA_ZGELQF_TILE(long long int *A, long long int *T,int *INFO)
{   *INFO = PLASMA_zgelqf_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T)); }

void PLASMA_ZGELQS_TILE(long long int *A, long long int *B, long long int *T, int *INFO)
{   *INFO = PLASMA_zgelqs_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T)); }

void PLASMA_ZGELS_TILE(PLASMA_enum *trans, long long int *A, long long int *B, long long int *T, int *INFO)
{   *INFO = PLASMA_zgels_Tile(*trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T)); }

void PLASMA_ZGEQRF_TILE(long long int *A, long long int *T, int *INFO)
{   *INFO = PLASMA_zgeqrf_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T)); }

void PLASMA_ZGEQRS_TILE(long long int *A, long long int *B, long long int *T, int *INFO)
{   *INFO = PLASMA_zgeqrs_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*B), (PLASMA_desc *)(*T)); }

void PLASMA_ZGESV_TILE(long long int *A, long long int *L, int **IPIVH, long long int *B, int *INFO)
{   *INFO = PLASMA_zgesv_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B)); }

void PLASMA_ZGETRF_TILE(long long int *A, long long int *L, int **IPIVH, int *INFO)
{   *INFO = PLASMA_zgetrf_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH); }

void PLASMA_ZGETRS_TILE(long long int *A, long long int *L, int **IPIVH, long long int *B, int *INFO)
{   *INFO = PLASMA_zgetrs_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B)); }

void PLASMA_ZPOSV_TILE(PLASMA_enum *uplo, long long int *A, long long int *B, int *INFO)
{   *INFO = PLASMA_zposv_Tile(*uplo, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B)); }

void PLASMA_ZPOTRF_TILE(PLASMA_enum *uplo, long long int *A, int *INFO)
{   *INFO = PLASMA_zpotrf_Tile(*uplo, (PLASMA_desc *)(*A)); }

void PLASMA_ZPOTRS_TILE(PLASMA_enum *uplo, long long int *A, long long int *B, int *INFO)
{   *INFO = PLASMA_zpotrs_Tile(*uplo, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B)); }

void PLASMA_ZTRSM_TILE(PLASMA_enum *side, PLASMA_enum *uplo, PLASMA_enum *transA, PLASMA_enum *diag, long long int *A, long long int *B, int *INFO)
{   *INFO = PLASMA_ztrsm_Tile(*side, *uplo, *transA, *diag, (PLASMA_desc *)(*A), (PLASMA_desc *)(*B)); }

void PLASMA_ZTRSMPL_TILE(long long int *A, long long int *L, int **IPIVH, long long int *B, int *INFO)
{   *INFO = PLASMA_ztrsmpl_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*L), *IPIVH, (PLASMA_desc *)(*B)); }

void PLASMA_ZUNQLQ_TILE(long long int *A, long long int *T, long long int *B, int *INFO)
{   *INFO = PLASMA_zunglq_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_ZUNGQR_TILE(long long int *A, long long int *T, long long int *B, int *INFO)
{   *INFO = PLASMA_zungqr_Tile((PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_ZUNMLQ_TILE(PLASMA_enum *side, PLASMA_enum *trans, long long int *A, long long int *T, long long int *B, int *INFO)
{   *INFO = PLASMA_zunmlq_Tile(*side, *trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

void PLASMA_ZUNMQR_TILE(PLASMA_enum *side, PLASMA_enum *trans, long long int *A, long long int *T, long long int *B, int *INFO)
{   *INFO = PLASMA_zunmqr_Tile(*side, *trans, (PLASMA_desc *)(*A), (PLASMA_desc *)(*T), (PLASMA_desc *)(*B)); }

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  FORTRAN API - workspace allocation
void PLASMA_ALLOC_WORKSPACE_ZGELQF(int *M, int *N, PLASMA_Complex64_t **T, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_zgelqf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_ZGELS(int *M, int *N, PLASMA_Complex64_t **T, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_zgels(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_ZGEQRF(int *M, int *N, PLASMA_Complex64_t **T, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_zgeqrf(*M, *N, T); }

void PLASMA_ALLOC_WORKSPACE_ZGESV(int *N, PLASMA_Complex64_t **L, int **IPIV, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_zgesv(*N, L, IPIV); }

void PLASMA_ALLOC_WORKSPACE_ZGETRF(int *M, int *N, PLASMA_Complex64_t **L, int **IPIV, int *INFO)
{   *INFO = PLASMA_Alloc_Workspace_zgetrf(*M, *N, L, IPIV); }

#ifdef __cplusplus
}
#endif
