/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.0.0)                          ///
 * ///                    Release Date: July, 4th 2009                                       ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#ifndef _PLASMA_LAPACK_H_
#define _PLASMA_LAPACK_H_

#ifdef ADD_
    #define spotrf spotrf_
    #define slamch slamch_
    #define slange slange_
    #define slansy slansy_
    #define slacpy slacpy_
    #define slarnv slarnv_
    #define slagsy slagsy_

    #define dpotrf dpotrf_
    #define dlamch dlamch_
    #define dlange dlange_
    #define dlansy dlansy_
    #define dlacpy dlacpy_
    #define dlarnv dlarnv_
    #define dlagsy dlagsy_

    #define cpotrf cpotrf_
    #define clamch clamch_
    #define clange clange_
    #define clansy clansy_
    #define clacpy clacpy_
    #define clarnv clarnv_
    #define claghe claghe_

    #define zpotrf zpotrf_
    #define zlamch zlamch_
    #define zlange zlange_
    #define zlansy zlansy_
    #define zlacpy zlacpy_
    #define zlarnv zlarnv_
    #define zlaghe zlaghe_

    #define zlag2c zlag2c_
    #define dlag2s dlag2s_
    #define clag2z clag2z_
    #define slag2d slag2d_
#endif

#ifdef __cplusplus
extern "C" {
#endif

float slamch(char*);
double dlamch(char*);

void spotrf(char*, int*, float*, int*, int*);
float slange(char*, int*, int*, float*, int*, float*);
float slansy(char*, char*, int*, float*, int*, float *);
void slacpy(char*, int*, int*, float*, int*, float*, int*);
void slarnv(int*, int*, int*, float*);
void slagsy(int*, int*, float*, float*, int*, int*, float*, int*);

void dpotrf(char*, int*, double*, int*, int*);
double dlange(char*, int*, int*, double*, int*, double*);
double dlansy(char*, char*, int*, double*, int*, double *);
void dlacpy(char*, int*, int*, double*, int*, double*, int*);
void dlarnv(int*, int*, int*, double*);
void dlagsy(int*, int*, double*, double*, int*, int*, double*, int*);

void cpotrf(char*, int*, PLASMA_Complex32_t *, int*, int*);
float clange(char*, int*, int*, PLASMA_Complex32_t *, int*, float *);
float clansy(char*, char*, int*, PLASMA_Complex32_t *, int*, float *);
void clacpy(char*, int*, int*, PLASMA_Complex32_t *, int*, PLASMA_Complex32_t *, int*);
void clarnv(int*, int*, int*, float _Complex *);
void claghe(int*, int*, float *, PLASMA_Complex32_t *, int*, int*, PLASMA_Complex32_t *, int*);

void zpotrf(char*, int*, PLASMA_Complex64_t *, int*, int*);
double zlange(char*, int*, int*, PLASMA_Complex64_t *, int*, double *);
double zlansy(char*, char*, int*, PLASMA_Complex64_t *, int*, double *);
void zlacpy(char*, int*, int*, PLASMA_Complex64_t *, int*, PLASMA_Complex64_t *, int*);
void zlarnv(int*, int*, int*, double _Complex *);
void zlaghe(int*, int*, double *, PLASMA_Complex64_t *, int*, int*, PLASMA_Complex64_t *, int*);

void dlag2s(int*, int*, double *, int*, float *, int *, int *);
void zlag2c(int*, int*, PLASMA_Complex64_t *, int*, PLASMA_Complex32_t *, int *, int *);
void slag2d(int*, int*, float *, int*, double *, int *, int *);
void clag2z(int*, int*, PLASMA_Complex32_t *, int*, PLASMA_Complex64_t *, int *, int *);

#ifdef __cplusplus
}
#endif

#endif
