/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.0.0)                          ///
 * ///                    Release Date: July, 4th 2009                                       ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#ifndef _PLASMA_CORE_ZBLAS_H_
#define _PLASMA_CORE_ZBLAS_H_

#ifdef ADD_
    #define zpotrf zpotrf_
    #define core_zgeqrt core_zgeqrt_
    #define core_ztsqrt core_ztsqrt_
    #define core_zunmqr core_zunmqr_
    #define core_zunmlq core_zunmlq_
    #define core_zssrfb core_zssrfb_
    #define core_zssmqr core_zssmqr_
    #define core_zssmlq core_zssmlq_
    #define core_zgelqt core_zgelqt_
    #define core_ztslqt core_ztslqt_
    #define core_zgetrf core_zgetrf_
    #define core_ztstrf core_ztstrf_
    #define core_zgessm core_zgessm_
    #define core_zssssm core_zssssm_
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  FORTRAN prototypes
void zpotrf(char*, int*, PLASMA_Complex64_t*, int*, int*);
void core_zgeqrt(int*, int*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, PLASMA_Complex64_t*, int*);
void core_ztsqrt(int*, int*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, PLASMA_Complex64_t*, int*);
void core_zunmqr(char*, char*, int*, int*, int*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, int*);
void core_zunmlq(char*, char*, int*, int*, int*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, int*);
void core_zssrfb(char*, char*, int*, int*, int*, int*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*);
void core_zssmqr(char*, char*, int*, int*, int*, int*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, int*);
void core_zssmlq(char*, char*, int*, int*, int*, int*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, int*);
void core_zgelqt(int*, int*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, PLASMA_Complex64_t*, int*);
void core_ztslqt(int*, int*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, PLASMA_Complex64_t*, int*);
void core_zgetrf(int*, int*, int*, PLASMA_Complex64_t*, int*, int*, int*);
void core_ztstrf(int*, int*, int*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, int *, PLASMA_Complex64_t*, int*, int*);
void core_zgessm(int*, int*, int*, int*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, int*);
void core_zssssm(int*, int*, int*, int*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, PLASMA_Complex64_t*, int*, int*, int*);

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  C prototypes
void CORE_zgelqt(int M, int N, int IB,
                 PLASMA_Complex64_t *A, int LDA,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK);
void CORE_zgemm(int transA, int transB,
                int M, int N, int K,
                PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA,
                PLASMA_Complex64_t *B, int LDB,
                PLASMA_Complex64_t beta, PLASMA_Complex64_t *C, int LDC);
void CORE_zgeqrt(int M, int N, int IB,
                 PLASMA_Complex64_t *A, int LDA,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK);
void CORE_zgessm(int M, int N, int K, int IB,
                 int *IPIV,
                 PLASMA_Complex64_t *L, int LDL,
                 PLASMA_Complex64_t *A, int LDA);
void CORE_zgetrf(int M, int N, int IB,
                 PLASMA_Complex64_t *A, int LDA,
                 int *IPIV, int *INFO);
void CORE_zpotrf(int uplo, int N, PLASMA_Complex64_t *A, int LDA, int *INFO);
void CORE_zssmlq(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex64_t *A1, int LDA1,
                 PLASMA_Complex64_t *A2, int LDA2,
                 PLASMA_Complex64_t *V, int LDV,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *WORK, int LDWORK);
void CORE_zssmqr(int side, int trans,
                 int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex64_t *A1, int LDA1,
                 PLASMA_Complex64_t *A2, int LDA2,
                 PLASMA_Complex64_t *V, int LDV,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *WORK, int LDWORK);
void CORE_zssssm(int M1, int M2, int NN, int IB, int K,
                 PLASMA_Complex64_t *A1, int LDA1,
                 PLASMA_Complex64_t *A2, int LDA2,
                 PLASMA_Complex64_t *L1, int LDL1,
                 PLASMA_Complex64_t *L2, int LDL2,
                 int *IPIV);
//#IFDEF COMPLEX .OR. COMPLEX_16
void CORE_zherk(int uplo, int trans,
                int N, int K,
                double alpha, PLASMA_Complex64_t *A, int LDA,
                double beta, PLASMA_Complex64_t *C, int LDC);
//#ENDIF
void CORE_zsyrk(int uplo, int trans,
                int N, int K,
                PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA,
                PLASMA_Complex64_t beta, PLASMA_Complex64_t *C, int LDC);
void CORE_ztrsm(int side, int uplo,
                int transA, int diag,
                int M, int N,
                PLASMA_Complex64_t alpha, PLASMA_Complex64_t *A, int LDA,
                PLASMA_Complex64_t *B, int LDB);
void CORE_ztslqt(int M, int N, int IB,
                 PLASMA_Complex64_t *A1, int LDA1,
                 PLASMA_Complex64_t *A2, int LDA2,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK);
void CORE_ztsqrt(int M, int N, int IB,
                 PLASMA_Complex64_t *A1, int LDA1,
                 PLASMA_Complex64_t *A2, int LDA2,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *TAU, PLASMA_Complex64_t *WORK);
void CORE_ztstrf(int M, int N, int IB, int NB,
                 PLASMA_Complex64_t *U, int LDU,
                 PLASMA_Complex64_t *A, int LDA,
                 PLASMA_Complex64_t *L, int LDL,
                 int *IPIV, PLASMA_Complex64_t *WORK,
                 int LDWORK, int *INFO);
void CORE_zunmlq(int side, int trans,
                 int M, int N, int IB, int K,
                 PLASMA_Complex64_t *V, int LDV,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *C, int LDC,
                 PLASMA_Complex64_t *WORK, int LDWORK);
void CORE_zunmqr(int side, int trans,
                 int M, int N, int IB, int K,
                 PLASMA_Complex64_t *V, int LDV,
                 PLASMA_Complex64_t *T, int LDT,
                 PLASMA_Complex64_t *C, int LDC,
                 PLASMA_Complex64_t *WORK, int LDWORK);

#ifdef __cplusplus
}
#endif

#endif
