!//////////////////////////////////////////////////////////////////////////////////////////////////
!  -- PLASMA --
!     University of Tennessee

!//////////////////////////////////////////////////////////////////////////////////////////////////
!    PLASMA constants - precisions
!
      integer  PlasmaByte, PlasmaInteger, PlasmaRealFloat
      integer  PlasmaRealDouble, PlasmaComplexFloat, PlasmaComplexDouble 
      parameter ( PlasmaByte          = 0 )
      parameter ( PlasmaInteger       = 1 )
      parameter ( PlasmaRealFloat     = 2 )
      parameter ( PlasmaRealDouble    = 3 )
      parameter ( PlasmaComplexFloat  = 4 )
      parameter ( PlasmaComplexDouble = 5 )

!//////////////////////////////////////////////////////////////////////////////////////////////////
!    PLASMA constants - CBLAS & LAPACK
!
      integer  PlasmaNoTrans, PlasmaTrans, PlasmaConjTrans
      parameter ( PlasmaNoTrans    = 111 )
      parameter ( PlasmaTrans      = 112 )
      parameter ( PlasmaConjTrans  = 113 )

      integer PlasmaUpper, PlasmaLower
      parameter ( PlasmaUpper      = 121 )
      parameter ( PlasmaLower      = 122 )

      integer PlasmaNonUnit,PlasmaUnit
      parameter ( PlasmaNonUnit    = 131 )
      parameter ( PlasmaUnit       = 132 )

      integer PlasmaLeft,PlasmaRight
      parameter ( PlasmaLeft       = 141 )
      parameter ( PlasmaRight      = 142 )

      integer PlasmaForward, PlasmaBackward
      parameter ( PlasmaForward    = 391 )
      parameter ( PlasmaBackward   = 392 )

      integer PlasmaColumnwise,PlasmaRowwise
      parameter ( PlasmaColumnwise = 401 )
      parameter ( PlasmaRowwise    = 402 )

!//////////////////////////////////////////////////////////////////////////////////////////////////
!  PLASMA constants - boolean
!
      integer PLASMA_FALSE, PLASMA_TRUE
      parameter ( PLASMA_FALSE = 0 )
      parameter ( PLASMA_TRUE  = 1 )

!//////////////////////////////////////////////////////////////////////////////////////////////////
!  State machine switches
!
      integer PLASMA_WARNINGS, PLASMA_AUTOTUNING
      parameter ( PLASMA_WARNINGS   = 1 )
      parameter ( PLASMA_AUTOTUNING = 2 )

!//////////////////////////////////////////////////////////////////////////////////////////////////
!   PLASMA constants - configuration  parameters
!
      integer PLASMA_CONCURRENCY, PLASMA_TILE_SIZE
      integer PLASMA_INNER_BLOCK_SIZE
      parameter ( PLASMA_CONCURRENCY      = 1 )
      parameter ( PLASMA_TILE_SIZE        = 2 )
      parameter ( PLASMA_INNER_BLOCK_SIZE = 3 )

!//////////////////////////////////////////////////////////////////////////////////////////////////
!  PLASMA constants - success & error codes
!
      integer PLASMA_SUCCESS, PLASMA_ERR_NOT_INITIALIZED
      integer PLASMA_ERR_REINITIALIZED, PLASMA_ERR_NOT_SUPPORTED
      integer PLASMA_ERR_ILLEGAL_VALUE, PLASMA_ERR_NOT_FOUND
      integer PLASMA_ERR_OUT_OF_MEMORY, PLASMA_ERR_INTERNAL_LIMIT
      integer PLASMA_ERR_UNALLOCATED, PLASMA_ERR_FILESYSTEM
      integer PLASMA_ERR_UNEXPECTED
      parameter ( PLASMA_SUCCESS             =    0 )
      parameter ( PLASMA_ERR_NOT_INITIALIZED = -101 )
      parameter ( PLASMA_ERR_REINITIALIZED   = -102 )
      parameter ( PLASMA_ERR_NOT_SUPPORTED   = -103 )
      parameter ( PLASMA_ERR_ILLEGAL_VALUE   = -104 )
      parameter ( PLASMA_ERR_NOT_FOUND       = -105 )
      parameter ( PLASMA_ERR_OUT_OF_MEMORY   = -106 )
      parameter ( PLASMA_ERR_INTERNAL_LIMIT  = -107 )
      parameter ( PLASMA_ERR_UNALLOCATED     = -108 )
      parameter ( PLASMA_ERR_FILESYSTEM      = -109 )
      parameter ( PLASMA_ERR_UNEXPECTED      = -110 )

