/* ///////////////////////////// P /// L /// A /// S /// M /// A /////////////////////////////// */
/* ///                    PLASMA auxiliary routines (version 2.0.0)                          ///
 * ///                    Release Date: July, 4th 2009                                       ///
 * ///                    PLASMA is a software package provided by Univ. of Tennessee,       ///
 * ///                    Univ. of California Berkeley and Univ. of Colorado Denver          /// */
/* ///////////////////////////////////////////////////////////////////////////////////////////// */
#ifndef _PLASMA_M_H_
#define _PLASMA_M_H_

#if defined(c_plusplus) || defined(__cplusplus)
extern "C" {
#endif

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Math function prototypes
int PLASMA_zcgesv(int N, int NRHS, PLASMA_Complex64_t *A, int LDA, PLASMA_Complex64_t *L, int *IPIV, PLASMA_Complex64_t *B, int LDB, PLASMA_Complex64_t *X, int LDX, int *ITER);
int PLASMA_dsgesv(int N, int NRHS, double *A, int LDA, double *L, int *IPIV, double *B, int LDB, double *X, int LDX, int *ITER);

/* ///////////////////////////////////////////////////////////////////////////////////////////// */
//  Math functions - native interface
int PLASMA_zcgesv_Tile(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, PLASMA_desc *X, int *ITER);
int PLASMA_dcgesv_Tile(PLASMA_desc *A, PLASMA_desc *L, int *IPIV, PLASMA_desc *B, PLASMA_desc *X, int *ITER);

#if defined(c_plusplus) || defined(__cplusplus)
}
#endif

#endif
