        PROGRAM EXAMPLE_ZPOSV_F

        IMPLICIT NONE

        include "plasmaf.h"
*
*    -- PLASMA FORTRAN EXAMPLE FOR ZPOSV
*       University of Tennessee
*       July 2009
*
*    -- Purpose
*       Example for solving a system of linear equations using Cholesky factorization
*
*================================================
*
*  .. VARIABLES

      INTEGER           CORES, N, NRHS, INFO
      PARAMETER         ( CORES = 2 )
      PARAMETER         ( N = 10 )
      PARAMETER         ( NRHS = 5 )
      COMPLEX*16  A( N, N ), B( N, NRHS ), WORK( 2*N )
      DOUBLE PRECISION  D( N )
      EXTERNAL          DLARNV, ZLAGHE
      EXTERNAL          PLASMA_INIT, PLASMA_ZPOSV, PLASMA_FINALIZE
      INTEGER           I
      INTEGER           ISEED( 4 )

      DO  I = 1, 4
          ISEED( I ) = 1
      ENDDO

!--   Initialization of the matrix
      CALL DLARNV( 1, ISEED, N, D )
      CALL ZLAGHE( N, N-1, D, A, N, ISEED, WORK, INFO )

!--   Make it definite positive
      DO I = 1, N
         A( I, I ) = A( I, I ) + N
      ENDDO

!--   Initialization of the RHS
      CALL ZLARNV( 1, ISEED, N*NRHS, B )

!--   Initialize Plasma
      CALL PLASMA_INIT( CORES, INFO )
      WRITE(*,*) " -- PLASMA is initialized on", CORES, "cores."

!--   Perform the Cholesky solve
      CALL PLASMA_ZPOSV( PlasmaUpper, N, NRHS, A, N, B, N, INFO )

      IF ( INFO < 0 ) THEN
          WRITE(*,*) " -- Error in ZPOSV example !"
      ELSE
          WRITE(*,*) " -- Run successful !"
      ENDIF

!--   Finalize Plasma
      CALL PLASMA_FINALIZE( INFO )

      END PROGRAM EXAMPLE_ZPOSV_F
