/*
 -- PLASMA ZPOSV Test Routine
    University of Tennessee
    July 2009

 -- Purpose
    Example for solving a system of linear equations using Cholesky factorization

*/

#include <stdlib.h>
#include <stdio.h>

#include <cblas.h>
#include <plasma.h>
#include "../src/lapack.h"

int main()
{
   int cores = 2;
   int N = 10;
   int NminusOne= N-1;
   int NRHS = 5;
   int NxNRHS = N*NRHS;
   int INFO;
   int IONE = 1;
   int ISEED[4] = {0,0,0,1};   /* initial seed for zlarnv() */
   int i;

   PLASMA_Complex64_t *A    = (PLASMA_Complex64_t *)malloc(N*N*sizeof(PLASMA_Complex64_t));
   PLASMA_Complex64_t *B    = (PLASMA_Complex64_t *)malloc(N*NRHS*sizeof(PLASMA_Complex64_t));
   PLASMA_Complex64_t *work = (PLASMA_Complex64_t *)malloc(2*N*sizeof(PLASMA_Complex64_t));
   double *D                = (double *)malloc(N*sizeof(double));

   /* Initialize A */
   dlarnv(&IONE, ISEED, &N, D);
   zlaghe(&N, &NminusOne, D, A, &N, ISEED, work, &INFO);

   /* Make it definite positive */
   for (i = 0; i < N; i++)
       A[i*N+i] += N;

   /* Initialize B */
   zlarnv(&IONE, ISEED, &NxNRHS, B);

   /* Plasma Initialize */
   INFO = PLASMA_Init(cores);
   printf("-- PLASMA is initialized to run on %d cores. \n",cores);

   /* Solve the problem */
   INFO = PLASMA_zposv(PlasmaUpper, N, NRHS, A, N, B, N);
   if (INFO < 0)
       printf("-- Error in ZPOSV example ! \n");
   else
       printf("-- Run of ZPOSV example successful ! \n");

   /* Plasma Finalize */
   INFO = PLASMA_Finalize();

   free(A); free(B); free(D); free(work);

   return 0;
}
