        PROGRAM EXAMPLE_ZGESV_F

        IMPLICIT NONE

        INCLUDE "plasmaf.h"
*
*    -- PLASMA FORTRAN EXAMPLE FOR ZGESV
*       University of Tennessee
*       July 2009
*
*    -- Purpose
*       Example for solving a system of linear equations using LU factorization
*
*================================================
*
*     .. VARIABLES

      INTEGER           CORES, N, NRHS, INFO
      PARAMETER         ( CORES = 2 )
      PARAMETER         ( N = 10 )
      PARAMETER         ( NRHS = 5 )
      COMPLEX*16  A( N, N ), B( N, NRHS )
      INTEGER*4         HL( 2 ), HPIV( 2 )
      EXTERNAL          ZLARNV
      EXTERNAL          PLASMA_INIT, PLASMA_ALLOC_WORKSPACE_ZGESV
      EXTERNAL          PLASMA_ZGESV, PLASMA_FINALIZE
      EXTERNAL          PLASMA_DEALLOC_HANDLE
      INTEGER           I
      INTEGER           ISEED( 4 )

      DO  I = 1, 4
          ISEED( I ) = 1
      ENDDO

!--   Initialization of the matrix
      CALL ZLARNV( 1, ISEED, N*N, A )

!--   Initialization of the RHS
      CALL ZLARNV( 1, ISEED, N*NRHS, B )

! --  Initialize Plasma
      CALL PLASMA_INIT( CORES, INFO )
      WRITE(*,*) " -- PLASMA is initialized on", CORES, "cores."

! --  Allocate L and IPIV
      CALL PLASMA_ALLOC_WORKSPACE_ZGESV( N, HL, HPIV, INFO )

! --  Perform the LU solve
      CALL PLASMA_ZGESV( N, NRHS, A, N, HL, HPIV, B, N, INFO )

      IF ( INFO < 0 ) THEN
          WRITE(*,*) " -- Error in ZGESV example !"
      ELSE
          WRITE(*,*) " -- Run successful !"
      ENDIF

! --  Deallocate L and IPIV
      CALL PLASMA_DEALLOC_HANDLE( HL, INFO )
      CALL PLASMA_DEALLOC_HANDLE( HPIV, INFO )

!--   Finalize Plasma
      CALL PLASMA_FINALIZE( INFO )

      END PROGRAM EXAMPLE_ZGESV_F
