/*
 -- PLASMA DGESV Test Routine
    University of Tennessee
    July 2009

 -- Purpose
    Example for solving a system of linear equations using LU factorization

*/

#include <stdlib.h>
#include <stdio.h>

#include <cblas.h>
#include <plasma.h>
#include "../src/lapack.h"

int main()
{
   int cores = 2;
   int N = 10;
   int NxN = N*N;
   int NRHS = 5;
   int NxNRHS = N*NRHS;
   int INFO;
   int IONE=1;
   int ISEED[4] = {0,0,0,1};   /* initial seed for zlarnv() */

   PLASMA_Complex64_t *A = (PLASMA_Complex64_t *)malloc(N*N*sizeof(PLASMA_Complex64_t));
   PLASMA_Complex64_t *B = (PLASMA_Complex64_t *)malloc(N*NRHS*sizeof(PLASMA_Complex64_t));
   PLASMA_Complex64_t *L;
   int *IPIV;

   /* Initialize A */
   zlarnv(&IONE, ISEED, &NxN, A);

   /* Initialize B */
   zlarnv(&IONE, ISEED, &NxNRHS, B);

    /* Plasma Initialize */
   INFO = PLASMA_Init(cores);
   printf("-- PLASMA is initialized to run on %d cores. \n",cores);

   /* Allocate L and IPIV */
   PLASMA_Alloc_Workspace_zgesv(N, &L, &IPIV);

   /* Solve the problem */
   INFO = PLASMA_zgesv(N, NRHS, A, N, L, IPIV, B, N);
   if (INFO < 0)
       printf("-- Error in ZGESV example ! \n");
   else
       printf("-- Run successful ! \n");

   /* Deallocate L and IPIV */
   free(L); free(IPIV);

   /* Plasma Finalize */
   INFO = PLASMA_Finalize();

   free(A); free(B);

   return 0;
}
