        PROGRAM EXAMPLE_ZGELS_F

        IMPLICIT NONE

        INCLUDE "plasmaf.h"
*
*    -- PLASMA FORTRAN EXAMPLE FOR ZGELS
*       University of Tennessee
*       July 2009
*
*    -- Purpose
*       Example for solving a system of linear equations using QR factorization
*
*================================================
*
*  .. VARIABLES

      INTEGER           CORES, M, N, NRHS, INFO
      PARAMETER         ( CORES = 2 )
      PARAMETER         ( M = 15 )
      PARAMETER         ( N = 10 )
      PARAMETER         ( NRHS = 5 )
      COMPLEX*16  A( M, N ), B( M, NRHS )
      INTEGER           HT( 2 )
      EXTERNAL          ZLARNV
      EXTERNAL          PLASMA_INIT, PLASMA_ALLOC_WORKSPACE_ZGELS
      EXTERNAL          PLASMA_ZGELS, PLASMA_FINALIZE
      EXTERNAL          PLASMA_DEALLOC_HANDLE
      INTEGER           I
      INTEGER           ISEED( 4 )

      DO  I = 1, 4
          ISEED( I ) = 1
      ENDDO

!--   Initialization of the matrix
      CALL ZLARNV( 1, ISEED, M*N, A )

!--   Initialization of the RHS
      CALL ZLARNV( 1, ISEED, M*NRHS, B )

!--   Initialize Plasma
      CALL PLASMA_INIT( CORES, INFO )
      WRITE(*,*) " -- PLASMA is initialized on", CORES, "cores."

! --  Allocate T
      CALL PLASMA_ALLOC_WORKSPACE_ZGELS( M, N, HT, INFO )

! --  Perform the QR solve
      CALL PLASMA_ZGELS( PlasmaNoTrans, M, N, NRHS,
     &                  A, M, HT, B, M, INFO )

      IF ( INFO < 0 ) THEN
          WRITE(*,*) " -- Error in ZGELS example !"
      ELSE
          WRITE(*,*) " -- Run successful !"
      ENDIF

! --  Deallocate T
      CALL PLASMA_DEALLOC_HANDLE( HT, INFO )

!--   Finalize Plasma
      CALL PLASMA_FINALIZE( INFO )

      END PROGRAM EXAMPLE_ZGELS_F
