/*
 -- PLASMA ZGELS example Routine
    University of Tennessee
    July 2009

 -- Purpose
    Example for solving a system of linear equations using QR factorization
*/

#include <stdlib.h>
#include <stdio.h>

#include <cblas.h>
#include <plasma.h>
#include "../src/lapack.h"

int main()
{
   int cores = 2;
   int M = 15;
   int N = 10;
   int MxN = M*N;
   int NRHS = 5;
   int MxNRHS = M*NRHS;
   int INFO;
   int IONE=1;
   int ISEED[4] = {0,0,0,1};   /* initial seed for zlarnv() */

   PLASMA_Complex64_t *A = (PLASMA_Complex64_t *)malloc(M*N*sizeof(PLASMA_Complex64_t));
   PLASMA_Complex64_t *B = (PLASMA_Complex64_t *)malloc(M*NRHS*sizeof(PLASMA_Complex64_t));
   PLASMA_Complex64_t *T;

   /* Initialize A */
   zlarnv(&IONE, ISEED, &MxN, A);

   /* Initialize B */
   zlarnv(&IONE, ISEED, &MxNRHS, B);

    /* Plasma Initialize */
   INFO = PLASMA_Init(cores);
   printf("-- PLASMA is initialized to run on %d cores. \n",cores);

   /* Allocate T */
   PLASMA_Alloc_Workspace_zgels(M, N, &T);

   /* Solve the problem */
   INFO = PLASMA_zgels(PlasmaNoTrans, M, N, NRHS, A, M, T, B, M);

   if (INFO < 0)
       printf("-- Error in ZGELS example ! \n");
   else
       printf("-- Run successful ! \n");

   /* Deallocate T */
   free(T);

   /* Plasma Finalize */
   INFO = PLASMA_Finalize();

   free(A); free(B);

   return 0;
}
