      SUBROUTINE CORE_ZUNMQR( SIDE, TRANS, M, N, IB, K,  A, LDA,
     $                       T, LDT, C, LDC, WORK, LDWORK, INFO )

*********************************************************************
*     PLASMA core_blas routine (version 2.0.0)                      *
*     Release Date: July, 4th 2009                                  *
*     PLASMA is a software package provided by Univ. of Tennessee,  *
*     Univ. of California Berkeley and Univ. of Colorado Denver.    *
*********************************************************************
*
*     .. Scalar Arguments ..
      CHARACTER          SIDE, TRANS
      INTEGER            M, N, K, IB, INFO
      INTEGER            LDA, LDT, LDC, LDWORK
*     ..
*     .. Array Arguments ..
      COMPLEX*16            A( LDA, * ), C( LDC, * )
      COMPLEX*16            T( LDT, * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  CORE_ZUNMQR overwrites the general complex M-by-N tile C with
*
*                  SIDE = 'L'     SIDE = 'R'
*  TRANS = 'N':      Q * C          C * Q
*  TRANS = 'C':      Q**H * C       C * Q**H
*
*  where Q is a complex unitary matrix defined as the product of k
*  elementary reflectors
*
*        Q = H(1) H(2) . . . H(k)
*
*  as returned by CORE_ZGEQRT. Q is of order M if SIDE = 'L' and of order N
*  if SIDE = 'R'.
*
*  Arguments
*  =========
*
*  SIDE    (input) CHARACTER*1
*          = 'L': apply Q or Q**H from the Left;
*          = 'R': apply Q or Q**H from the Right.
*
*  TRANS   (input) CHARACTER*1
*          = 'N':  No transpose, apply Q;
*          = 'T':  Transpose, apply Q**H.
*
*  M       (input) INTEGER
*          The number of rows of the tile C. M >= 0.
*
*  N       (input) INTEGER
*          The number of columns of the tile C. N >= 0.
*
*  K       (input) INTEGER
*          The number of elementary reflectors whose product defines
*          the matrix Q.
*          If SIDE = 'L', M >= K >= 0;
*          if SIDE = 'R', N >= K >= 0.
*
*  A       (input) COMPLEX*16 array, dimension (LDA,K)
*          The i-th column must contain the vector which defines the
*          elementary reflector H(i), for i = 1,2,...,k, as returned by
*          CORE_ZGEQRT in the first k columns of its array argument A.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.
*          If SIDE = 'L', LDA >= max(1,M);
*          if SIDE = 'R', LDA >= max(1,N).
*
*  C       (input/output) COMPLEX*16 array, dimension (LDC,N)
*          On entry, the M-by-N tile C.
*          On exit, C is overwritten by Q*C or Q**T*C or C*Q**T or C*Q.
*
*  LDC     (input) INTEGER
*          The leading dimension of the array C. LDC >= max(1,M).
*
*  WORK    (workspace/output) COMPLEX*16 array, dimension (MAX(1,LDWORK))
*          On exit, if INFO = 0, WORK(1) returns the optimal LDWORK.
*
*  LDWORK   (input) INTEGER
*          The dimension of the array WORK.
*          If SIDE = 'L', LDWORK >= max(1,N);
*          if SIDE = 'R', LDWORK >= max(1,M).
*
*  INFO    (output) INTEGER
*          = 0:  successful exit
*          < 0:  if INFO = -i, the i-th argument had an illegal value
*
*  =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            LEFT, NOTRAN
      INTEGER            I, I1, I2, I3, KB, IC, IINFO, JC,
     $                   MI, NI, NQ, NW
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. External Subroutines ..
      EXTERNAL           ZLARFB, XERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN
*     ..
*     .. Executable Statements ..
*
*     Test the input arguments
*
      INFO = 0
      LEFT = LSAME( SIDE, 'L' )
      NOTRAN = LSAME( TRANS, 'N' )
*
*     Quick return if possible
*
      IF( M.EQ.0 .OR. N.EQ.0 .OR. IB.EQ.0 .OR. K.EQ.0 ) THEN
         RETURN
      END IF
*
*     NQ is the order of Q and NW is the minimum dimension of WORK
*
      IF( LEFT ) THEN
         NQ = M
         NW = N
      ELSE
         NQ = N
         NW = M
      END IF
      IF( .NOT.LEFT .AND. .NOT.LSAME( SIDE, 'R' ) ) THEN
         INFO = -1
      ELSE IF( .NOT.NOTRAN .AND. .NOT.LSAME( TRANS, 'C' ) ) THEN
         INFO = -2
      ELSE IF( M.LT.0 ) THEN
         INFO = -3
      ELSE IF( N.LT.0 ) THEN
         INFO = -4
      ELSE IF( IB.LT.0 ) THEN
         INFO = -5
      ELSE IF( K.LT.0 .OR. K.GT.NQ ) THEN
         INFO = -6
      ELSE IF( LDA.LT.MAX( 1, NQ ) ) THEN
         INFO = -8
      ELSE IF( LDC.LT.MAX( 1, M ) ) THEN
         INFO = -12
      ELSE IF( LDWORK.LT.MAX( 1, NW ) ) THEN
         INFO = -14
      END IF
*
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( 'CORE_ZUNMQR', -INFO )
         RETURN
      END IF
*
      IF( ( LEFT .AND. .NOT.NOTRAN ) .OR.
     $    ( .NOT.LEFT .AND. NOTRAN ) ) THEN
         I1 = 1
         I2 = K
         I3 = IB
      ELSE
         I1 = ( ( K-1 ) / IB )*IB + 1
         I2 = 1
         I3 = -IB
      END IF
*
      IF( LEFT ) THEN
         NI = N
         JC = 1
      ELSE
         MI = M
         IC = 1
      END IF
*
      DO 10 I = I1, I2, I3
         KB = MIN( IB, K-I+1 )
         IF( LEFT ) THEN
*
*           H or H' is applied to C(i:m,1:n)
*
            MI = M - I + 1
            IC = I
         ELSE
*
*           H or H' is applied to C(1:m,i:n)
*
            NI = N - I + 1
            JC = I
         END IF
*
*        Apply H or H'
*
         CALL ZLARFB( SIDE, TRANS, 'Forward', 'Columnwise', MI, NI,
     $               KB, A( I, I ), LDA, T( 1, I ), LDT,
     $               C( IC, JC ), LDC, WORK, LDWORK )
   10 CONTINUE
      RETURN
*
*     End of CORE_ZUNMQR
*
      END
