      SUBROUTINE CORE_DTSTRF( M, N, IB, NB, U, LDU, A, LDA,
     $                        L, LDL, IPIV, INFO)

      IMPLICIT NONE
      INTEGER  M, N, IB, NB, LDU, LDA, LDL, INFO
      INTEGER  IPIV( * )
      DOUBLE PRECISION U(LDU, *), A(LDA, *), L(LDL, *), Ltmp(LDA,N)

*
*     Internal variables
*
      INTEGER I, II, J, KB, MODK, IM, IP, IDAMAX
      EXTERNAL IDAMAX

*
*     Test the input parameters.
*
      INFO = 0
      IF( M.LT.0 ) THEN
         INFO = -1
      ELSE IF( N.LT.0 ) THEN
         INFO = -2
      ELSE IF( IB.LT.0 ) THEN
         INFO = -3
      ELSE IF( LDU.LT.MAX( 1, M ) ) THEN
         INFO = -6
      ELSE IF( LDA.LT.MAX( 1, M ) ) THEN
         INFO = -8
      ELSE IF( LDL.LT.MAX( 1, IB ) ) THEN
         INFO = -10
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( 'CORE_DTSTRF', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( M.EQ.0 .OR. N.EQ.0 .OR. IB.EQ.0 )
     $   RETURN


      KB = N / IB
      MODK = MOD(N,IB)

      IP=1

      DO 20 II=1, KB*IB, IB

         DO 10 I=II, II+IB-1

            IM = IDAMAX(M, A(1,I), 1)

            IF(DABS(A(IM,I)) .GT. U(I,I)) THEN
*
*              Swap behind
*
               CALL DSWAP(I-II, L(I-II+1,II), LDL, Ltmp(IM, II), LDA)

*
*              Swap ahead
*
               CALL DSWAP(II+IB-I, U(I,I), LDU, A(IM, I), LDA)
*
*              Set IPIV
*
               IPIV(IP) = NB + IM

               DO 50 J=1,I-II
                    A(IM,II+J-1)=0.d0
 50            CONTINUE

            ELSE
               IPIV(IP) = I
            END IF

            CALL DSCAL(M, 1/U(I,I), A(1, I), 1)
            CALL DCOPY(M, A(1,I), 1, Ltmp(1,I), 1)

            CALL DGER(M, II+IB-I-1, -1.D0,
     $           A(1,I), 1,
     $           U(I,I+1), LDU,
     $           A(1,I+1), LDA)

            IP = IP+1

 10      CONTINUE

*
*        Apply the subpanel to the rest of the panel
*
         IF (I .LE. N) THEN

            DO 80 J=II, II+IB-1
                  IF ( IPIV(J).LE.NB ) THEN
                     IPIV(J)=IPIV(J)-II+1
                  ENDIF
 80         CONTINUE

            CALL CORE_DSSSSM( NB, M, N-II-IB+1,
     $               IB, IB, IPIV(II),
     $               L( 1, II ), LDL, 
     $               Ltmp( 1, II ), LDA, 
     $               U( II, II+IB ), LDU, 
     $               A( 1, II+IB ), LDA, INFO)


            DO 70 J=II, II+IB-1
                  IF ( IPIV(J).LE.NB ) THEN
                     IPIV(J)=IPIV(J)+II-1
                  ENDIF
 70         CONTINUE


         END IF


 20   CONTINUE



*
*     CLEANUP CODE SECTION
*




      IF (MODK.GT.0) THEN

         DO 40 I=II, II+MODK-1

            IM = IDAMAX(M, A(1,I), 1)

            IF(DABS(A(IM,I)) .GT. U(I,I)) THEN
*
*              Swap behind
*
               CALL DSWAP(I-II, L(I-II+1,II), LDL, Ltmp(IM, II), LDA)
*
*              Swap ahead
*
               CALL DSWAP(II+MODK-I, U(I,I), LDU, A(IM, I), LDA)
*
*              Set IPIV
*
               IPIV(IP) = NB + IM

               DO 60 J=1,I-II
                    A(IM,II+J-1)=0.d0
 60            CONTINUE

            ELSE
               IPIV(IP) = I
            END IF

            CALL DSCAL(M, 1/U(I,I), A(1, I), 1)
            CALL DCOPY(M, A(1,I), 1, Ltmp(1,I), 1)

            CALL DGER(M, II+MODK-I-1, -1.D0,
     $           A(1,I), 1,
     $           U(I,I+1), LDU,
     $           A(1,I+1), LDA)

            IP = IP+1

 40      CONTINUE

*
*        Apply the subpanel to the rest of the panel
*
         IF (I .LE. N) THEN

            DO 90 J=II, II+MODK-1
                  IF ( IPIV(J).LE.NB ) THEN
                     IPIV(J)=IPIV(J)-II+1
                  ENDIF
 90         CONTINUE
            CALL CORE_DSSSSM( NB, M, N-II-MODK+1,
     $               MODK, MODK, IPIV(II),
     $               L( 1, II ), LDL, 
     $               Ltmp( 1, II ), LDA, 
     $               U( II, II+MODK ), LDU, 
     $               A( 1, II+MODK ), LDA, INFO)
            DO 100 J=II, II+MODK-1
                   IF ( IPIV(J).LE.NB ) THEN
                      IPIV(J)=IPIV(J)-II+1
                   ENDIF
 100        CONTINUE


         END IF


      ENDIF 


      RETURN
*
*     End of CORE_DTSTRF
*
      END


