      SUBROUTINE CORE_DTSQRT(M, N, IB, A1, LDA1, A2, LDA2, T, LDT, 
     $     TAU, WORK, INFO )

      IMPLICIT NONE
*
*  -- LAPACK routine (version 3.1) --
*     Univ. of Tennessee, Univ. of California Berkeley and NAG Ltd..
*     November 2006
*
*     .. Scalar Arguments ..
      INTEGER            INFO, LDA1, LDA2, LDT, M, N, IB
*     ..
*     .. Array Arguments ..
      DOUBLE PRECISION   A1( LDA1, * ), A2( LDA2, * ), TAU( * ), 
     $     WORK( * ), T( LDT, * )
*     ..
*
*  Purpose
*  =======
*
*  DGEQR2 computes a QR factorization of a real m by n matrix A:
*  A = Q * R.
*
*  Arguments
*  =========
*
*  M       (input) INTEGER
*          The number of rows of the matrix A.  M >= 0.
*
*  N       (input) INTEGER
*          The number of columns of the matrix A.  N >= 0.
*
*  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
*          On entry, the m by n matrix A.
*          On exit, the elements on and above the diagonal of the array
*          contain the min(m,n) by n upper trapezoidal matrix R (R is
*          upper triangular if m >= n); the elements below the diagonal,
*          with the array TAU, represent the orthogonal matrix Q as a
*          product of elementary reflectors (see Further Details).
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.  LDA >= max(1,M).
*
*  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
*          The scalar factors of the elementary reflectors (see Further
*          Details).
*
*  WORK    (workspace) DOUBLE PRECISION array, dimension (N)
*
*  INFO    (output) INTEGER
*          = 0: successful exit
*          < 0: if INFO = -i, the i-th argument had an illegal value
*
*  Further Details
*  ===============
*
*  The matrix Q is represented as a product of elementary reflectors
*
*     Q = H(1) H(2) . . . H(k), where k = min(m,n).
*
*  Each H(i) has the form
*
*     H(i) = I - tau * v * v'
*
*  where tau is a real scalar, and v is a real vector with
*  v(1:i-1) = 0 and v(i) = 1; v(i+1:m) is stored on exit in A(i+1:m,i),
*  and tau in TAU(i).
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0 )
      PARAMETER          ( ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, II, J, KB, MODK, IINFO
      DOUBLE PRECISION   AII
*     ..
*     .. External Subroutines ..
      EXTERNAL           DLARF, DLARFG, XERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN
*     ..
*     .. Executable Statements ..
*
*     Test the input arguments
*
      INFO = 0
      IF( M.LT.0 ) THEN
         INFO = -1
      ELSE IF( N.LT.0 ) THEN
         INFO = -2
      ELSE IF( IB.LT.0 ) THEN
         INFO = -3
      ELSE IF( LDA2.LT.MAX( 1, M ) ) THEN
         INFO = -7
      END IF

      IF( INFO.NE.0 ) THEN
         CALL XERBLA( 'CORE_DTSQRT', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( M.EQ.0 .OR. N.EQ.0 .OR. IB.EQ.0 )
     $   RETURN
*
      KB = N / IB
      MODK = MOD(N,IB)

      DO 20 II = 0, KB-1
         DO 10 I = 1, IB
*
*           Generate elementary reflector H(i) to annihilate A(i+1:m,i)
*
            CALL DLARFG(M+1, A1(II*IB+I, II*IB+I), A2( 1, II*IB+I ), 1,
     $           TAU( II*IB+I ) )
*
            IF( (II*IB+I).LT.N ) THEN
*
*              Apply H(i) to A(i:m,i+1:i+ib-1) from the left
*
               CALL DCOPY(IB-I, A1(II*IB+I,II*IB+I+1), LDA1, WORK, 1)
               CALL DGEMV('Transpose', M, IB-I, ONE, A2(1,II*IB+I+1), 
     $              LDA2, A2(1,II*IB+I), 1, ONE, WORK, 1)

               CALL DAXPY(IB-I, -TAU(II*IB+I), WORK, 1, 
     &              A1(II*IB+I,II*IB+I+1), LDA1) 
               CALL DGER(M, IB-I, -TAU(II*IB+I), A2(1,II*IB+I), 1, 
     $              WORK, 1, A2(1,II*IB+I+1), LDA2)


            END IF
*
*           Compute T
*
            CALL DGEMV( 'Transpose', M, I-1, -TAU(II*IB+I),
     $           A2( 1, II*IB+1 ), LDA2, A2( 1, II*IB+I ), 1, ZERO,
     $           T( 1, II*IB+I ), 1 )
*
            CALL DTRMV('Upper','NoTranspose','Nonunit',I-1 ,
     $           T(1, II*IB+1), LDT, T( 1, II*IB+I ), 1 )
            T( I, II*IB+I ) = TAU( II*IB+I )

 10      CONTINUE

         CALL CORE_DSSRFB('L','C',IB,M,N-IB*(II+1),IB,IB,
     $                 A1(II*IB+1,IB*(II+1)+1), LDA1,
     $                 A2(1,IB*(II+1)+1), LDA2,
     $                 A2(1, II*IB+1), LDA2,
     $                 T(1,II*IB+1), LDT, WORK, IINFO)


 20   CONTINUE



*
*     CLEAN-UP CODE SECTION
*


      IF (MODK.GT.0) THEN
         DO 40 I = 1, MODK
*
*           Generate elementary reflector H(i) to annihilate A(i+1:m,i)
*
            CALL DLARFG(M+1, A1(II*IB+I, II*IB+I), A2( 1, II*IB+I ), 1,
     $           TAU( II*IB+I ) )
            IF( (II*IB+I).LT.N ) THEN
*
*              Apply H(i) to A(i:m,i+1:i+ib-1) from the left
*
               CALL DCOPY(MODK-I, A1(II*IB+I,II*IB+I+1), LDA1, WORK,1)
               CALL DGEMV('Transpose', M, MODK-I, ONE,A2(1,II*IB+I+1),
     $              LDA2, A2(1,II*IB+I), 1, ONE, WORK, 1)

               CALL DAXPY(MODK-I, -TAU(II*IB+I), WORK, 1, 
     &              A1(II*IB+I,II*IB+I+1), LDA1) 
               CALL DGER(M, MODK-I, -TAU(II*IB+I), A2(1,II*IB+I), 1, 
     $              WORK, 1, A2(1,II*IB+I+1), LDA2)

            END IF

*
*           Compute T
*
            CALL DGEMV( 'Transpose', M, I-1, -TAU(II*IB+I),
     $           A2( 1, II*IB+1 ), LDA2, A2( 1, II*IB+I ), 1, ZERO,
     $           T( 1, II*IB+I ), 1 )
*
            CALL DTRMV('Upper','Notranspose','Nonunit',I-1 ,
     $           T(1, II*IB+1), LDT, T( 1, II*IB+I ), 1 )
            T( I, II*IB+I ) = TAU( II*IB+I )

 40      CONTINUE

      ENDIF 


      RETURN
*
*     End of CORE_DTSQRT
*
      END
