      SUBROUTINE CORE_DSSSSM(M1, M2, NN, IB, K, IPIV, L0, LDL0,
     $                       L1, LDL1, A0, LDA0, A1, LDA1, INFO)

      IMPLICIT NONE

      INTEGER M1, M2, IB, NN, K
      INTEGER LDL0, LDL1, LDA0, LDA1, INFO
      INTEGER IPIV( * )
      DOUBLE PRECISION L0(LDL0,*), L1(LDL1,*), A0(LDA0,*), A1(LDA1,*)
*
*     Internal variables
*
      INTEGER II, I, IP, IM, KB, MODK

*
*     Test the input parameters.
*

      INFO = 0
      IF( M1.LT.0 ) THEN
         INFO = -1
      ELSE IF( M2.LT.0 ) THEN
         INFO = -2
      ELSE IF( NN.LT.0 ) THEN
         INFO = -3
      ELSE IF( IB.LT.0 ) THEN
         INFO = -4
      ELSE IF( K.LT.0 ) THEN
         INFO = -5
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( 'CORE_DTSTRF', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( M1.EQ.0 .OR. M2.EQ.0 .OR. NN.EQ.0 .OR. IB.EQ.0  .OR. K.EQ.0 )
     $   RETURN

      KB = K / IB
      MODK = MOD(K,IB)


      IP = 1

      DO 10 II=1, KB*IB, IB

         DO 20 I=II, II+IB-1

            IM = IPIV(IP)
            IF(IM .NE. I) THEN
               IM = IM - M1
               CALL DSWAP(NN, A0(I,1), LDA0, A1(IM,1), LDA1)
            END IF
            IP = IP+1

 20      CONTINUE

         CALL DTRSM('LEFT', 'LOWER', 'NOTRAN', 'UNIT',
     $        IB, NN,
     $        1.D0,
     $        L0(1,II), LDL0,
     $        A0(II, 1), LDA0)


         CALL DGEMM('NOTRAN', 'NOTRAN',
     $        M2, NN, IB,
     $        -1.D0,
     $        L1(1,II), LDL1,
     $        A0(II,1), LDA0,
     $        1.D0,
     $        A1(1,1), LDA1)

 10   CONTINUE



*
*     CLEAN-UP CODE SECTION
*




      IF (MODK.GT.0) THEN

         DO 30 I=II, II+MODK-1

            IM = IPIV(IP)
            IF(IM .NE. I) THEN
               IM = IM - M1
               CALL DSWAP(NN, A0(I,1), LDA0, A1(IM,1), LDA1)
            END IF
            IP = IP+1

 30      CONTINUE

         CALL DTRSM('LEFT', 'LOWER', 'NOTRAN', 'UNIT',
     $        MODK, NN,
     $        1.D0,
     $        L0(1,II), LDL0,
     $        A0(II, 1), LDA0)

         CALL DGEMM('NOTRAN', 'NOTRAN',
     $        M2, NN, MODK,
     $        -1.D0,
     $        L1(1,II), LDL1,
     $        A0(II,1), LDA0,
     $        1.D0,
     $        A1(1,1), LDA1)



      ENDIF


      RETURN
*
*     End of CORE_DSSSSM
*

      END
