      SUBROUTINE CORE_DGETRF( M, N, IB, A, LDA, L, LDL, IPIV, INFO )
*
*  -- LAPACK routine (version 3.1) --
*     Univ. of Tennessee, Univ. of California Berkeley and NAG Ltd..
*     November 2006
*
*     .. Scalar Arguments ..
      INTEGER            INFO, LDA, LDL, M, N, IB
*     ..
*     .. Array Arguments ..
      INTEGER            IPIV( * )
      DOUBLE PRECISION   A( LDA, * ), L( LDL, *)
*     ..
*
*  Purpose
*  =======
*
*  DGETF2 computes an LU factorization of a general m-by-n matrix A
*  using partial pivoting with row interchanges.
*
*  The factorization has the form
*     A = P * L * U
*  where P is a permutation matrix, L is lower triangular with unit
*  diagonal elements (lower trapezoidal if m > n), and U is upper
*  triangular (upper trapezoidal if m < n).
*
*  This is the right-looking Level 2 BLAS version of the algorithm.
*
*  Arguments
*  =========
*
*  M       (input) INTEGER
*          The number of rows of the matrix A.  M >= 0.
*
*  N       (input) INTEGER
*          The number of columns of the matrix A.  N >= 0.
*
*  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
*          On entry, the m by n matrix to be factored.
*          On exit, the factors L and U from the factorization
*          A = P*L*U; the unit diagonal elements of L are not stored.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.  LDA >= max(1,M).
*
*  IPIV    (output) INTEGER array, dimension (min(M,N))
*          The pivot indices; for 1 <= i <= min(M,N), row i of the
*          matrix was interchanged with row IPIV(i).
*
*  INFO    (output) INTEGER
*          = 0: successful exit
*          < 0: if INFO = -k, the k-th argument had an illegal value
*          > 0: if INFO = k, U(k,k) is exactly zero. The factorization
*               has been completed, but the factor U is exactly
*               singular, and division by zero will occur if it is used
*               to solve a system of equations.
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      DOUBLE PRECISION   SFMIN 
      INTEGER            I, J, K, MODK, KB, JP, IINFO
*     ..
*     .. External Functions ..
      DOUBLE PRECISION   DLAMCH      
      INTEGER            IDAMAX
      EXTERNAL           DLAMCH, IDAMAX
*     ..
*     .. External Subroutines ..
      EXTERNAL           DGER, DSCAL, DSWAP, XERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN
*     ..
*     .. Executable Statements ..
*
*     Test the input parameters.
*
      INFO = 0
      IF( M.LT.0 ) THEN
         INFO = -1
      ELSE IF( N.LT.0 ) THEN
         INFO = -2
      ELSE IF( IB.LT.0 ) THEN
         INFO = -3
      ELSE IF( LDA.LT.MAX( 1, M ) ) THEN
         INFO = -5
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( 'CORE_DGETRF', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( M.EQ.0 .OR. N.EQ.0 .OR. IB.EQ.0 )
     $   RETURN
*
*     Compute machine safe minimum 
* 
      SFMIN = DLAMCH('S')  
*
      K = MIN( M, N )
      KB = K / IB
      MODK = MOD(K,IB)
*
      DO 10 J = 0, KB-1
*
*           Factor diagonal and subdiagonal blocks and test for exact
*           singularity.
*
            CALL DGETF2( M-J*IB, IB, A( J*IB+1, J*IB+1 ), LDA, 
     $                   IPIV( J*IB+1 ), IINFO )

*
*           Adjust INFO and the pivot indices.
*
            IF( INFO.EQ.0 .AND. IINFO.GT.0 )
     $          INFO = IINFO + J*IB


*
            IF( J*IB+1+IB.LE.N ) THEN

                CALL CORE_DGESSM(M-J*IB,N-J*IB-IB,IB,IB,IPIV(J*IB+1),
     $                           A( J*IB+1, J*IB+1 ), LDL, 
     $                           A( J*IB+1, J*IB+IB+1 ), LDA, INFO)
 
            END IF


            DO 20 I = J*IB+1, J*IB+IB
                  IPIV( I ) = J*IB + IPIV( I )
   20       CONTINUE

   10 CONTINUE


*
*     CLEAN-UP CODE SECTION
*


      IF (MODK.GT.0) THEN
*
*           Factor diagonal and subdiagonal blocks and test for exact
*           singularity.
*
            CALL DGETF2( M-J*IB, MODK, A( J*IB+1, J*IB+1 ), LDA, 
     $                   IPIV( J*IB+1 ), IINFO )

*
*           Adjust INFO and the pivot indices.
*
            IF( INFO.EQ.0 .AND. IINFO.GT.0 )
     $          INFO = IINFO + J*IB

            IF( J*IB+1+MODK.LE.N ) THEN

             CALL CORE_DGESSM(M-J*IB,N-J*IB-MODK,MODK,MODK,IPIV(J*IB+1),
     $                        A( J*IB+1, J*IB+1 ), LDL, 
     $                        A( J*IB+1, J*IB+MODK+1 ), LDA, INFO)
 
            END IF

            DO 30 I = J*IB+1, J*IB+MODK
                  IPIV( I ) = J*IB + IPIV( I )
   30       CONTINUE


      ENDIF 


      RETURN
*
*     End of CORE_DGETRF
*
      END
