      SUBROUTINE CORE_DGESSM(M, N, K, IB, IPIV, L, LDL, A, LDA, INFO)

      IMPLICIT NONE

      INTEGER M, N, K, IB, LDL, LDA, INFO
      DOUBLE PRECISION L(LDL,*), A(LDA,*)
      INTEGER IPIV( * )
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*
*     LOCAL VARIABLES      
*
      INTEGER I, J, IM, KB, MODK
*
*     Test the input parameters.
*
      INFO = 0
      IF( M.LT.0 ) THEN
         INFO = -1
      ELSE IF( N.LT.0 ) THEN
         INFO = -2
      ELSE IF( K.LT.0 ) THEN
         INFO = -3
      ELSE IF( IB.LT.0 ) THEN
         INFO = -4      
      ELSE IF( LDL.LT.MAX( 1, M ) ) THEN
         INFO = -7
      ELSE IF( LDA.LT.MAX( 1, M ) ) THEN
         INFO = -9
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( 'CORE_DGESSM', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( M.EQ.0 .OR. N.EQ.0 .OR. K.EQ.0 .OR. IB.EQ.0  )
     $   RETURN      

      KB = K / IB
      MODK = MOD(K,IB)

      DO 10 J = 0, KB-1
*
*           Apply interchanges to columns J*IB+1:IB*(J+1)+1.
*
            CALL DLASWP( N, A, LDA, J*IB+1, J*IB+IB, IPIV, 1 )
*
*           Compute block row of U.
*
            CALL DTRSM( 'Left', 'Lower', 'No transpose', 'Unit', IB,
     $                  N, ONE, L( J*IB+1, J*IB+1 ), LDL,
     $                  A( J*IB+1, 1 ), LDA )

            IF( J*IB+1+IB.LE.M ) THEN
*
*               Update trailing submatrix.
*
                CALL DGEMM( 'No transpose', 'No transpose', M-J*IB-IB,
     $                      N, IB, -ONE, 
     $                      L( J*IB+1+IB, J*IB+1 ), LDL,
     $                      A( J*IB+1, 1 ), LDA, ONE,
     $                      A( J*IB+1+IB, 1 ), LDA )
            END IF

   10 CONTINUE


*
*     CLEAN-UP CODE SECTION
*

      IF (MODK.GT.0) THEN
*
*        Apply interchanges to columns J*IB+1:J*IB+1+MODK.
*
         CALL DLASWP( N, A, LDA, J*IB+1, J*IB+MODK, IPIV, 1 )
*
*        Compute block row of U.
*
         CALL DTRSM( 'Left', 'Lower', 'No transpose', 'Unit', MODK,
     $               N, ONE, L( J*IB+1, J*IB+1 ), LDL,
     $               A( J*IB+1, 1 ), LDA )

         IF( J*IB+1+MODK.LE.M ) THEN
*
*            Update trailing submatrix.
*
             CALL DGEMM( 'No transpose', 'No transpose', M-J*IB-MODK,
     $                   N, MODK, -ONE, 
     $                   L( J*IB+1+MODK, J*IB+1 ), LDL,
     $                   A( J*IB+1, 1 ), LDA, ONE,
     $                   A( J*IB+1+MODK, 1 ), LDA )
         END IF

      ENDIF 

      RETURN
*
*     End of CORE_DGESSM
*
      END
