! ////////////////////////////////////////////////////////////////////////////////////////
!  -- PLASMA --
!     University of Tennessee
!
!#ifndef _PLASMA_H_
!#define _PLASMA_H_

!#if defined(c_plusplus) || defined(__cplusplus)
!extern "C" {
!#endif

!////////////////////////////////////////////////////////////////////////////////////////
! *  PLASMA types
! 
!#define PLASMA_enum INTEGER
!#define PLASMA_bool INTEGER
!#define PLASMA_long INTEGER 

! ////////////////////////////////////////////////////////////////////////////////////////
! *  PLASMA constants - CBLAS & LAPACK
! 

	integer PlasmaNoTrans, PlasmaTrans, PlasmaConjTrans
	parameter (PlasmaNoTrans=111)
	parameter (PlasmaTrans=112)
	parameter (PlasmaConjTrans=113)

	integer PlasmaUpper, PlasmaLower
	parameter (PlasmaUpper=121)
	parameter (PlasmaLower=122)

	integer PlasmaNonUnit,PlasmaUnit
	parameter (PlasmaNonUnit=131)
	parameter (PlasmaUnit=132)

	integer PlasmaLeft,PlasmaRight
	parameter (PlasmaLeft=141)
	parameter (PlasmaRight=142)

	integer PlasmaForward, PlasmaBackward
	parameter (PlasmaForward=391)
	parameter (PlasmaBackward=392)

	integer PlasmaColumnwise,PlasmaRowwise
	parameter (PlasmaColumnwise=401)
	parameter (PlasmaRowwise=402)

!#define plasma_const_neg(const) (((const-1)^0x01)+1)

!////////////////////////////////////////////////////////////////////////////////////////
!  PLASMA constants - boolean
!
	integer PLASMA_FALSE, PLASMA_TRUE
	parameter (PLASMA_FALSE=0)
	parameter (PLASMA_TRUE=1)

!////////////////////////////////////////////////////////////////////////////////////////
!	typedef long PLASMA_long
!   PLASMA constants - configuration  parameters
!
	integer PLASMA_CONCURRENCY
	parameter (PLASMA_CONCURRENCY=1)

!////////////////////////////////////////////////////////////////////////////////////////
!  PLASMA constants - success & error codes
!
	integer PLASMA_SUCCESS, PLASMA_ERR_NOT_INITIALIZED
	integer PLASMA_ERR_REINITIALIZED, PLASMA_ERR_NOT_SUPPORTED
	integer PLASMA_ERR_ILLEGAL_VALUE, PLASMA_ERR_NOT_FOUND
	integer PLASMA_ERR_OUT_OF_MEMORY, PLASMA_ERR_INTERNAL_LIMIT
	integer PLASMA_ERR_UNALLOCATED, PLASMA_ERR_FILESYSTEM
	parameter (PLASMA_SUCCESS=0)
	parameter (PLASMA_ERR_NOT_INITIALIZED=-1)
	parameter (PLASMA_ERR_REINITIALIZED=-2)
	parameter (PLASMA_ERR_NOT_SUPPORTED=-3)
	parameter (PLASMA_ERR_ILLEGAL_VALUE=-4)
	parameter (PLASMA_ERR_NOT_FOUND=-5)
	parameter (PLASMA_ERR_OUT_OF_MEMORY=-6)
	parameter (PLASMA_ERR_INTERNAL_LIMIT =-7)
	parameter (PLASMA_ERR_UNALLOCATED=-8)
	parameter (PLASMA_ERR_FILESYSTEM=-9)

!////////////////////////////////////////////////////////////////////////////////////////
!  LAPACK Constants
!
!*extern char *lapack_constants[];

*#define lapack_const(plasma_const) lapack_constants[plasma_const]

!////////////////////////////////////////////////////////////////////////////////////////
!  Function prototypes
! 
!int plasma_init(int M, int N, int NRHS);
!int plasma_finalize();

! int plasma_DGELS(PLASMA_enum trans, int M, int N, int NRHS, double *A,
!                 int LDA, double *B, int LDB);

!int plasma_DPOSV(PLASMA_enum uplo, int N, int NRHS, double *A, int LDA,
!                 double *B, int LDB, int *INFO);

!if defined(c_plusplus) || defined(__cplusplus)
!}
!#endif

!#endif
